/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.crypto.transaction.account.AccountKey;
import org.web3j.crypto.transaction.account.AccountKeyDecoder;
import org.web3j.crypto.transaction.account.AccountKeyPublic;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.AccountKeyPublicUtils;
import org.web3j.utils.BytesUtils;
import org.web3j.utils.Numeric;

public class AccountKeyWeightedMultiSig
implements AccountKey {
    private BigInteger threshold;
    private List<WeightedPublicKey> weightedPublicKeys = new ArrayList<WeightedPublicKey>();

    public static AccountKeyWeightedMultiSig create(BigInteger threshold, List<WeightedPublicKey> weightedPublicKeys) {
        return new AccountKeyWeightedMultiSig(threshold, weightedPublicKeys);
    }

    public AccountKeyWeightedMultiSig() {
    }

    public AccountKeyWeightedMultiSig(BigInteger threshold, List<WeightedPublicKey> weightedPublicKeys) {
        this.threshold = threshold;
        this.weightedPublicKeys.addAll(weightedPublicKeys);
    }

    public BigInteger getThreshold() {
        return this.threshold;
    }

    @JsonProperty(value="keys")
    public List<WeightedPublicKey> getWeightedPublicKeys() {
        return this.weightedPublicKeys;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)this.threshold));
        ArrayList<RlpList> rlpWeightedPublicKeys = new ArrayList<RlpList>();
        for (WeightedPublicKey item : this.weightedPublicKeys) {
            ArrayList<RlpString> rlpWeightedPublicKey = new ArrayList<RlpString>();
            rlpWeightedPublicKey.addAll(Arrays.asList(RlpString.create((BigInteger)item.weight), RlpString.create((byte[])Numeric.hexStringToByteArray((String)item.key.toCompressedPublicKey()))));
            rlpWeightedPublicKeys.add(new RlpList(rlpWeightedPublicKey));
        }
        rlpTypeList.add(new RlpList(rlpWeightedPublicKeys));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{this.getType().getValue()};
        return BytesUtils.concat(type, encodedTransaction);
    }

    public static AccountKeyWeightedMultiSig decodeFromRlp(byte[] rawTransaction) {
        byte[] transaction = AccountKeyDecoder.getRawTransactionNoType(rawTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        BigInteger threshold = ((RlpString)values.getValues().get(0)).asPositiveBigInteger();
        ArrayList<WeightedPublicKey> weightedPublicKeys = new ArrayList<WeightedPublicKey>();
        RlpList rlpWeightedPublicKeys = (RlpList)values.getValues().get(1);
        for (RlpType item : rlpWeightedPublicKeys.getValues()) {
            RlpList rlpWeightedPublicKey = (RlpList)item;
            BigInteger weight = ((RlpString)rlpWeightedPublicKey.getValues().get(0)).asPositiveBigInteger();
            String compressedPublicKey = ((RlpString)rlpWeightedPublicKey.getValues().get(1)).asString();
            weightedPublicKeys.add(new WeightedPublicKey(weight, AccountKeyPublicUtils.decompressKey(compressedPublicKey)));
        }
        return new AccountKeyWeightedMultiSig(threshold, weightedPublicKeys);
    }

    public static AccountKeyWeightedMultiSig decodeFromRlp(String hexString) {
        return AccountKeyWeightedMultiSig.decodeFromRlp(Numeric.hexStringToByteArray((String)hexString));
    }

    @Override
    public AccountKey.Type getType() {
        return AccountKey.Type.MULTISIG;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountKeyWeightedMultiSig that = (AccountKeyWeightedMultiSig)o;
        return Arrays.equals(this.toRlp(), that.toRlp());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("AccountKeyWeightedMultiSig : {\n");
        for (WeightedPublicKey weightedPublicKey : this.weightedPublicKeys) {
            result.append("{Weight : " + weightedPublicKey.weight + " / ");
            result.append("PublicKey : " + weightedPublicKey.key.toString() + "}\n ");
        }
        result.append("}");
        return result.toString();
    }

    public static class WeightedPublicKey {
        private BigInteger weight;
        private AccountKeyPublic key;

        public WeightedPublicKey() {
        }

        protected WeightedPublicKey(BigInteger weight, AccountKeyPublic key) {
            this.weight = weight;
            this.key = key;
        }

        public static WeightedPublicKey create(BigInteger weight, AccountKeyPublic accountKeyPublic) {
            return new WeightedPublicKey(weight, accountKeyPublic);
        }

        public BigInteger getWeight() {
            return this.weight;
        }

        public AccountKeyPublic getKey() {
            return this.key;
        }
    }
}

