/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.crypto.transaction.account.AccountKey;
import org.web3j.crypto.transaction.account.AccountKeyDecoder;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.BytesUtils;
import org.web3j.utils.Numeric;

public class AccountKeyRoleBased
implements AccountKey {
    private List<AccountKey> accountKeys;

    protected AccountKeyRoleBased(List<AccountKey> accountKeys) {
        this.accountKeys = accountKeys;
    }

    public static AccountKeyRoleBased create(List<AccountKey> roleBasedAccountKeys) {
        return new AccountKeyRoleBased(roleBasedAccountKeys);
    }

    public AccountKey getRoleTransaction() {
        return this.accountKeys.get(0);
    }

    public AccountKey getRoleUpdate() {
        return this.accountKeys.get(1);
    }

    public AccountKey getRoleFeePayer() {
        return this.accountKeys.get(2);
    }

    public List<AccountKey> getAccountKeys() {
        return this.accountKeys;
    }

    public static AccountKeyRoleBased decodeFromRlp(byte[] rawTransaction) {
        byte[] transaction = AccountKeyDecoder.getRawTransactionNoType(rawTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        ArrayList<AccountKey> accountKeys = new ArrayList<AccountKey>();
        for (RlpType value : values) {
            accountKeys.add(AccountKeyDecoder.fromRlp(((RlpString)value).asString()));
        }
        return AccountKeyRoleBased.create(accountKeys);
    }

    public static AccountKeyRoleBased decodeFromRlp(String hexString) {
        return AccountKeyRoleBased.decodeFromRlp(Numeric.hexStringToByteArray((String)hexString));
    }

    @Override
    public byte[] toRlp() {
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        for (AccountKey roleBasedAccountKey : this.accountKeys) {
            rlpTypeList.add(RlpString.create((byte[])roleBasedAccountKey.toRlp()));
        }
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{this.getType().getValue()};
        return BytesUtils.concat(type, encodedTransaction);
    }

    @Override
    public AccountKey.Type getType() {
        return AccountKey.Type.ROLEBASED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountKeyRoleBased that = (AccountKeyRoleBased)o;
        return Arrays.equals(this.toRlp(), that.toRlp());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("AccountKeyRoleBased : \n ");
        result.append("RoleTransaction : \n " + this.getRoleTransaction().toString() + "\n ");
        result.append("RoleUpdate : \n " + this.getRoleUpdate().toString() + "\n ");
        result.append("RoleFeePayer : \n " + this.getRoleFeePayer().toString());
        return result.toString();
    }
}

