/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.account;

import org.web3j.crypto.transaction.account.AccountKeyFail;
import org.web3j.crypto.transaction.account.AccountKeyLegacy;
import org.web3j.crypto.transaction.account.AccountKeyNil;
import org.web3j.crypto.transaction.account.AccountKeyPublic;
import org.web3j.crypto.transaction.account.AccountKeyRoleBased;
import org.web3j.crypto.transaction.account.AccountKeyWeightedMultiSig;

public interface AccountKey {
    public Type getType();

    public byte[] toRlp();

    public static enum Type {
        NIL(0, AccountKeyNil.class),
        LEGACY(1, AccountKeyLegacy.class),
        PUBLIC(2, AccountKeyPublic.class),
        FAIL(3, AccountKeyFail.class),
        MULTISIG(4, AccountKeyWeightedMultiSig.class),
        ROLEBASED(5, AccountKeyRoleBased.class);

        private byte value;
        private Class keyClass;

        private Type(byte value, Class keyClass) {
            this.value = value;
            this.keyClass = keyClass;
        }

        public byte getValue() {
            return this.value;
        }

        public Class getKeyClass() {
            return this.keyClass;
        }

        public static Type findByValue(byte value) {
            for (Type v : Type.values()) {
                if (v.getValue() != value) continue;
                return v;
            }
            return PUBLIC;
        }
    }
}

