/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.example;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.KlayTransactionEncoder;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedCancelWithRatio;
import org.web3j.example.keySample;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.klaytn.Web3j;
import org.web3j.protocol.klaytn.core.method.response.KlayGetTransactionReceiptResponse;
import org.web3j.protocol.klaytn.core.method.response.TransactionReceipt;
import org.web3j.utils.Numeric;

public class FeeDelegatedCancelWithRatioExample
implements keySample {
    public static void run() throws IOException {
        Web3j web3j = Web3j.build((Web3jService)new HttpService("https://public-en-baobab.klaytn.net"));
        KlayCredentials credentials = KlayCredentials.create("0x0e4ca6d38096ad99324de0dde108587e5d7c600165ae4cd6c2462c597458c2b8");
        KlayCredentials credentials_feepayer = KlayCredentials.create("0x9435261ed483b6efa3886d6ad9f64c12078a0e28d8d80715c773e16fc000cff4");
        BigInteger GAS_PRICE = BigInteger.valueOf(50000000000L);
        BigInteger GAS_LIMIT = BigInteger.valueOf(6721950L);
        String from = credentials.getAddress();
        EthChainId EthchainId = (EthChainId)web3j.ethChainId().send();
        long chainId = EthchainId.getChainId().longValue();
        BigInteger nonce = ((EthGetTransactionCount)web3j.ethGetTransactionCount(from, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getTransactionCount();
        BigInteger feeRatio = BigInteger.valueOf(30L);
        TxType.Type type = TxType.Type.FEE_DELEGATED_CANCEL_WITH_RATIO;
        KlayRawTransaction raw = KlayRawTransaction.createTransaction(type, nonce, GAS_PRICE, GAS_LIMIT, from, feeRatio);
        byte[] signedMessage = KlayTransactionEncoder.signMessage(raw, chainId, credentials);
        signedMessage = KlayTransactionEncoder.signMessageAsFeePayer(raw, chainId, credentials_feepayer);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction transactionResponse = (EthSendTransaction)web3j.ethSendRawTransaction(hexValue).send();
        System.out.println("TxHash : \n " + (String)transactionResponse.getResult());
        String txHash = (String)transactionResponse.getResult();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        TransactionReceipt receipt = ((KlayGetTransactionReceiptResponse)web3j.klayGetTransactionReceipt(txHash).send()).getResult();
        System.out.println("receipt : \n" + receipt);
        web3j.shutdown();
        TxTypeFeeDelegatedCancelWithRatio rawTransaction = TxTypeFeeDelegatedCancelWithRatio.decodeFromRawTransaction(signedMessage);
        System.out.println("TxType : " + rawTransaction.getKlayType());
    }
}

