/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.util.List;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.KlaySignatureData;
import org.web3j.rlp.RlpType;

public interface TxType {
    public KlaySignatureData getSignatureData(KlayCredentials var1, int var2);

    public KlayRawTransaction sign(KlayCredentials var1, long var2);

    public List<RlpType> rlpValues();

    public Type getKlayType();

    public byte[] getEncodedTransactionNoSig();

    public static enum Type {
        LEGACY(0),
        ACCOUNT_CREATION(24),
        ACCOUNT_UPDATE(32),
        FEE_DELEGATED_ACCOUNT_UPDATE(33),
        FEE_DELEGATED_ACCOUNT_UPDATE_WITH_RATIO(34),
        VALUE_TRANSFER(8),
        VALUE_TRANSFER_MEMO(16),
        FEE_DELEGATED_VALUE_TRANSFER(9),
        FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO(10),
        FEE_DELEGATED_VALUE_TRANSFER_MEMO(17),
        FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO(18),
        SMART_CONTRACT_DEPLOY(40),
        FEE_DELEGATED_SMART_CONTRACT_DEPLOY(41),
        FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO(42),
        SMART_CONTRACT_EXECUTION(48),
        FEE_DELEGATED_SMART_CONTRACT_EXECUTION(49),
        FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO(50),
        CANCEL(56),
        FEE_DELEGATED_CANCEL(57),
        FEE_DELEGATED_CANCEL_WITH_RATIO(58),
        CHAIN_DATA_ANCHORING(72),
        FEE_DELEGATED_CHAIN_DATA_ANCHORING(73),
        FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO(74);

        private byte value;

        private Type(byte value) {
            this.value = value;
        }

        public byte get() {
            return this.value;
        }

        public static Type findByValue(byte value) {
            for (Type v : Type.values()) {
                if (v.get() != value) continue;
                return v;
            }
            return LEGACY;
        }

        public static boolean isFeeDelegated(Type type) {
            return type == FEE_DELEGATED_ACCOUNT_UPDATE || type == FEE_DELEGATED_CANCEL || type == FEE_DELEGATED_SMART_CONTRACT_DEPLOY || type == FEE_DELEGATED_SMART_CONTRACT_EXECUTION || type == FEE_DELEGATED_VALUE_TRANSFER || type == FEE_DELEGATED_VALUE_TRANSFER_MEMO || type == FEE_DELEGATED_CHAIN_DATA_ANCHORING;
        }

        public static boolean isPartialFeeDelegated(Type type) {
            return type == FEE_DELEGATED_ACCOUNT_UPDATE_WITH_RATIO || type == FEE_DELEGATED_CANCEL_WITH_RATIO || type == FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO || type == FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO || type == FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO || type == FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO || type == FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO;
        }
    }
}

