/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import org.web3j.crypto.Credentials;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.transaction.fee.FeePayer;
import org.web3j.crypto.transaction.type.AbstractTxType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeAccountUpdate;
import org.web3j.crypto.transaction.type.TxTypeCancel;
import org.web3j.crypto.transaction.type.TxTypeChainDataAnchoring;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegate;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedCancel;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedCancelWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedChainDataAnchoring;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedChainDataAnchoringWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractDeploy;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractDeployWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractExecution;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractExecutionWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransfer;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferMemo;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferMemoWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferWithRatio;
import org.web3j.crypto.transaction.type.TxTypeSmartContractDeploy;
import org.web3j.crypto.transaction.type.TxTypeSmartContractExecution;
import org.web3j.crypto.transaction.type.TxTypeValueTransfer;
import org.web3j.crypto.transaction.type.TxTypeValueTransferMemo;
import org.web3j.utils.KlayTransactionUtils;

public class KlayTransactionEncoder
extends TransactionEncoder {
    public static byte[] signMessage(RawTransaction rawTransaction, long chainId, KlayCredentials credentials) {
        if (credentials.isDeCoupled()) {
            throw new Error("a legacy transaction must be with a legacy account key");
        }
        return KlayTransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)chainId, (Credentials)credentials.convertToCredentials());
    }

    public static byte[] signMessage(RawTransaction rawTransaction, KlayCredentials credentials) {
        if (credentials.isDeCoupled()) {
            throw new Error("a legacy transaction must be with a legacy account key");
        }
        return KlayTransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credentials.convertToCredentials());
    }

    public static byte[] signMessage(KlayRawTransaction rawTransaction, KlayCredentials credentials) {
        AbstractTxType tx = (AbstractTxType)rawTransaction.getTransaction();
        long chainId = tx.getChainId();
        if (TxType.Type.isFeeDelegated(tx.getKlayType()) || TxType.Type.isPartialFeeDelegated(tx.getKlayType())) {
            TxTypeFeeDelegate senderTx = (TxTypeFeeDelegate)rawTransaction.getTransaction();
            return senderTx.sign(credentials, chainId).getRaw();
        }
        return tx.sign(credentials, chainId).getRaw();
    }

    public static byte[] signMessage(KlayRawTransaction rawTransaction, long chainId, KlayCredentials credentials) {
        AbstractTxType tx = (AbstractTxType)rawTransaction.getTransaction();
        if (TxType.Type.isFeeDelegated(tx.getKlayType()) || TxType.Type.isPartialFeeDelegated(tx.getKlayType())) {
            TxTypeFeeDelegate senderTx = (TxTypeFeeDelegate)rawTransaction.getTransaction();
            return senderTx.sign(credentials, chainId).getRaw();
        }
        return tx.sign(credentials, chainId).getRaw();
    }

    public static byte[] signMessageAsFeePayer(KlayRawTransaction rawTransaction, long chainId, KlayCredentials credentials) {
        TxTypeFeeDelegate senderTx = (TxTypeFeeDelegate)rawTransaction.getTransaction();
        senderTx.setFeePayer(credentials.getAddress());
        KlayRawTransaction payerTx = new FeePayer(credentials, chainId).sign(senderTx);
        return payerTx.getRaw();
    }

    public static byte[] signMessageAsFeePayer(KlayRawTransaction rawTransaction, KlayCredentials credentials) {
        TxTypeFeeDelegate senderTx = (TxTypeFeeDelegate)rawTransaction.getTransaction();
        long chainId = senderTx.getChainId();
        senderTx.setFeePayer(credentials.getAddress());
        KlayRawTransaction payerTx = new FeePayer(credentials, chainId).sign(senderTx);
        return payerTx.getRaw();
    }

    public static byte[] signMessage(byte[] encodedSenderTransaction, long chainId, KlayCredentials credentials) {
        TxTypeFeeDelegate encodedTx;
        TxType.Type type = KlayTransactionUtils.getType(encodedSenderTransaction);
        if (!TxType.Type.isFeeDelegated(type) && !TxType.Type.isPartialFeeDelegated(type)) {
            AbstractTxType encodedTx2;
            switch (type) {
                case ACCOUNT_UPDATE: {
                    encodedTx2 = TxTypeAccountUpdate.decodeFromRawTransaction(encodedSenderTransaction);
                    break;
                }
                case CANCEL: {
                    encodedTx2 = TxTypeCancel.decodeFromRawTransaction(encodedSenderTransaction);
                    break;
                }
                case SMART_CONTRACT_DEPLOY: {
                    encodedTx2 = TxTypeSmartContractDeploy.decodeFromRawTransaction(encodedSenderTransaction);
                    break;
                }
                case SMART_CONTRACT_EXECUTION: {
                    encodedTx2 = TxTypeSmartContractExecution.decodeFromRawTransaction(encodedSenderTransaction);
                    break;
                }
                case VALUE_TRANSFER: {
                    encodedTx2 = TxTypeValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
                    break;
                }
                case VALUE_TRANSFER_MEMO: {
                    encodedTx2 = TxTypeValueTransferMemo.decodeFromRawTransaction(encodedSenderTransaction);
                    break;
                }
                case CHAIN_DATA_ANCHORING: {
                    encodedTx2 = TxTypeChainDataAnchoring.decodeFromRawTransaction(encodedSenderTransaction);
                    break;
                }
                default: {
                    encodedTx2 = TxTypeValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
                }
            }
            return encodedTx2.sign(credentials, chainId).getRaw();
        }
        switch (type) {
            case FEE_DELEGATED_CANCEL: {
                encodedTx = TxTypeFeeDelegatedCancel.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_CANCEL_WITH_RATIO: {
                encodedTx = TxTypeFeeDelegatedCancelWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_DEPLOY: {
                encodedTx = TxTypeFeeDelegatedSmartContractDeploy.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO: {
                encodedTx = TxTypeFeeDelegatedSmartContractDeployWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_EXECUTION: {
                encodedTx = TxTypeFeeDelegatedSmartContractExecution.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO: {
                encodedTx = TxTypeFeeDelegatedSmartContractExecutionWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER: {
                encodedTx = TxTypeFeeDelegatedValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_MEMO: {
                encodedTx = TxTypeFeeDelegatedValueTransferMemo.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO: {
                encodedTx = TxTypeFeeDelegatedValueTransferWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO: {
                encodedTx = TxTypeFeeDelegatedValueTransferMemoWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO: {
                encodedTx = TxTypeFeeDelegatedChainDataAnchoringWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_CHAIN_DATA_ANCHORING: {
                encodedTx = TxTypeFeeDelegatedChainDataAnchoring.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            default: {
                encodedTx = TxTypeFeeDelegatedValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
            }
        }
        return encodedTx.sign(credentials, chainId).getRaw();
    }

    public static byte[] signMessageAsFeePayer(byte[] encodedSenderTransaction, long chainId, KlayCredentials credentials) {
        TxTypeFeeDelegate senderTx;
        TxType.Type type = KlayTransactionUtils.getType(encodedSenderTransaction);
        switch (type) {
            case FEE_DELEGATED_CANCEL: {
                senderTx = TxTypeFeeDelegatedCancel.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_CANCEL_WITH_RATIO: {
                senderTx = TxTypeFeeDelegatedCancelWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_DEPLOY: {
                senderTx = TxTypeFeeDelegatedSmartContractDeploy.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO: {
                senderTx = TxTypeFeeDelegatedSmartContractDeployWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_EXECUTION: {
                senderTx = TxTypeFeeDelegatedSmartContractExecution.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO: {
                senderTx = TxTypeFeeDelegatedSmartContractExecutionWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER: {
                senderTx = TxTypeFeeDelegatedValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_MEMO: {
                senderTx = TxTypeFeeDelegatedValueTransferMemo.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO: {
                senderTx = TxTypeFeeDelegatedValueTransferWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO: {
                senderTx = TxTypeFeeDelegatedValueTransferMemoWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_CHAIN_DATA_ANCHORING: {
                senderTx = TxTypeFeeDelegatedChainDataAnchoring.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            case FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO: {
                senderTx = TxTypeFeeDelegatedChainDataAnchoringWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
                break;
            }
            default: {
                senderTx = TxTypeFeeDelegatedValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
            }
        }
        KlayRawTransaction payerTx = new FeePayer(credentials, chainId).sign(senderTx);
        return payerTx.getRaw();
    }
}

