/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.service;

import org.web3j.crypto.Credentials;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.KlayTransactionEncoder;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;

public class TxKlaySignServiceImpl {
    private final KlayCredentials credentials;

    public TxKlaySignServiceImpl(KlayCredentials credentials) {
        this.credentials = credentials;
    }

    public TxKlaySignServiceImpl(Credentials credentials) {
        this.credentials = KlayCredentials.create(credentials.getEcKeyPair());
    }

    public byte[] sign(KlayRawTransaction rawTransaction, long chainId) {
        byte[] signedMessage = chainId > -1L ? KlayTransactionEncoder.signMessage(rawTransaction, chainId, this.credentials) : KlayTransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)this.credentials.convertToCredentials());
        return signedMessage;
    }

    public byte[] sign(RawTransaction rawTransaction, long chainId) {
        byte[] signedMessage = chainId > -1L ? TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)chainId, (Credentials)this.credentials.convertToCredentials()) : TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)this.credentials.convertToCredentials());
        return signedMessage;
    }

    public String getAddress() {
        return this.credentials.getAddress();
    }
}

