/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.AbstractTxType;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.KlayTransactionUtils;
import org.web3j.utils.Numeric;

public class TxTypeChainDataAnchoring
extends AbstractTxType {
    private final byte[] anchoredData;

    protected TxTypeChainDataAnchoring(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData) {
        super(type, nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.anchoredData = anchoredData;
    }

    public static TxTypeChainDataAnchoring createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData) {
        return new TxTypeChainDataAnchoring(type, nonce, gasPrice, gasLimit, from, anchoredData);
    }

    protected TxTypeChainDataAnchoring(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData) {
        super(chainId, type, nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.anchoredData = anchoredData;
    }

    public static TxTypeChainDataAnchoring createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData) {
        return new TxTypeChainDataAnchoring(chainId, type, nonce, gasPrice, gasLimit, from, anchoredData);
    }

    public byte[] getAnchoredData() {
        return this.anchoredData;
    }

    @Override
    public List<RlpType> rlpValues() {
        List<RlpType> values = super.rlpValues();
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        values.add((RlpType)RlpString.create((byte[])this.getAnchoredData()));
        return values;
    }

    @Override
    public TxType.Type getKlayType() {
        return TxType.Type.CHAIN_DATA_ANCHORING;
    }

    public static TxTypeChainDataAnchoring decodeFromRawTransaction(byte[] rawTransaction) {
        byte[] rawTransactionExceptType = KlayTransactionUtils.getRawTransactionNoType(rawTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])rawTransactionExceptType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
        String from = ((RlpString)values.get(3)).asString();
        byte[] payload = ((RlpString)values.get(4)).getBytes();
        TxType.Type type = TxType.Type.CHAIN_DATA_ANCHORING;
        TxTypeChainDataAnchoring tx = new TxTypeChainDataAnchoring(type, nonce, gasPrice, gasLimit, from, payload);
        tx.addSignatureData(values, 5);
        return tx;
    }

    public static TxTypeChainDataAnchoring decodeFromRawTransaction(String rawTransaction) {
        return TxTypeChainDataAnchoring.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        return null;
    }

    public String getData() {
        return null;
    }

    public TransactionType getType() {
        return null;
    }
}

