/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.account.AccountKey;
import org.web3j.crypto.transaction.account.AccountKeyDecoder;
import org.web3j.crypto.transaction.type.AbstractTxType;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.KlayTransactionUtils;
import org.web3j.utils.Numeric;

public class TxTypeAccountUpdate
extends AbstractTxType {
    private final AccountKey accountKey;

    public TxTypeAccountUpdate(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, AccountKey accountKey) {
        super(type, nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.accountKey = accountKey;
    }

    public static TxTypeAccountUpdate createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, AccountKey accountKey) {
        return new TxTypeAccountUpdate(type, nonce, gasPrice, gasLimit, from, accountKey);
    }

    public TxTypeAccountUpdate(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, AccountKey accountKey) {
        super(chainId, type, nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.accountKey = accountKey;
    }

    public static TxTypeAccountUpdate createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, AccountKey accountKey) {
        return new TxTypeAccountUpdate(chainId, type, nonce, gasPrice, gasLimit, from, accountKey);
    }

    public AccountKey getAccountKey() {
        return this.accountKey;
    }

    @Override
    public List<RlpType> rlpValues() {
        List<RlpType> values = super.rlpValues();
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        values.add((RlpType)RlpString.create((byte[])this.getAccountKey().toRlp()));
        return values;
    }

    @Override
    public TxType.Type getKlayType() {
        return TxType.Type.ACCOUNT_UPDATE;
    }

    public static TxTypeAccountUpdate decodeFromRawTransaction(byte[] rawTransaction) {
        try {
            byte[] rawTransactionExceptType = KlayTransactionUtils.getRawTransactionNoType(rawTransaction);
            RlpList rlpList = RlpDecoder.decode((byte[])rawTransactionExceptType);
            List values = ((RlpList)rlpList.getValues().get(0)).getValues();
            BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
            BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
            BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
            String from = ((RlpString)values.get(3)).asString();
            String rawAccountKey = ((RlpString)values.get(4)).asString();
            TxType.Type type = TxType.Type.ACCOUNT_UPDATE;
            TxTypeAccountUpdate tx = TxTypeAccountUpdate.createTransaction(type, nonce, gasPrice, gasLimit, from, AccountKeyDecoder.fromRlp(rawAccountKey));
            tx.addSignatureData(values, 5);
            return tx;
        }
        catch (Exception e) {
            throw new RuntimeException("There is a error in the processing of decoding tx");
        }
    }

    public static TxTypeAccountUpdate decodeFromRawTransaction(String rawTransaction) {
        return TxTypeAccountUpdate.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        throw new UnsupportedOperationException("Unimplemented method 'asRlpValues'");
    }

    public String getData() {
        throw new UnsupportedOperationException("Unimplemented method 'getData'");
    }

    public TransactionType getType() {
        throw new UnsupportedOperationException("Unimplemented method 'getType'");
    }
}

