/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class KlayCredentials {
    private final ECKeyPair ecKeyPair;
    private final String address;

    private KlayCredentials(ECKeyPair ecKeyPair, String address) {
        this.ecKeyPair = ecKeyPair;
        this.address = !Strings.isEmpty((String)address) ? Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)address), (int)40) : "";
    }

    public ECKeyPair getEcKeyPair() {
        return this.ecKeyPair;
    }

    public String getAddress() {
        return this.address;
    }

    public static KlayCredentials create(String privateKey) {
        ECKeyPair ecKeyPair = ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey));
        String address = Numeric.prependHexPrefix((String)Keys.getAddress((ECKeyPair)ecKeyPair));
        return KlayCredentials.create(ecKeyPair, address);
    }

    public static KlayCredentials create(ECKeyPair ecKeyPair) {
        String address = Numeric.prependHexPrefix((String)Keys.getAddress((ECKeyPair)ecKeyPair));
        return KlayCredentials.create(ecKeyPair, address);
    }

    public static KlayCredentials create(String privateKey, String address) {
        return KlayCredentials.create(ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey)), Numeric.prependHexPrefix((String)address));
    }

    public Credentials convertToCredentials() {
        Credentials Ethcredentials = Credentials.create((ECKeyPair)this.getEcKeyPair());
        return Ethcredentials;
    }

    public boolean isDeCoupled() {
        String address = Numeric.prependHexPrefix((String)Keys.getAddress((ECKeyPair)this.ecKeyPair));
        return !address.equals(this.address);
    }

    public static boolean isDeCoupled(String privKey, String address) {
        ECKeyPair ecKeyPair = ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privKey));
        return !address.equals(Numeric.prependHexPrefix((String)Keys.getAddress((ECKeyPair)ecKeyPair)));
    }

    public static KlayCredentials create(ECKeyPair ecKeyPair, String address) {
        return new KlayCredentials(ecKeyPair, address);
    }

    public static KlayCredentials createWithKlaytnWalletKey(String klaytnWalletKey) {
        klaytnWalletKey = Numeric.cleanHexPrefix((String)klaytnWalletKey);
        String privateKey = klaytnWalletKey.substring(0, 64);
        String address = klaytnWalletKey.substring(68);
        return KlayCredentials.create(privateKey, address);
    }
}

