/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.klayAccount;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.web3j.crypto.KlayCredentials;
import org.web3j.klayAccount.AccountInfo;
import org.web3j.klayAccount.Accounts;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.klaytn.Web3j;
import org.web3j.protocol.klaytn.core.method.response.EthGetAccountResponse;
import org.web3j.protocol.klaytn.core.method.response.KlayGetAccount;

public class AccountStore {
    private final HashMap<String, AccountInfo> AccountLists = new HashMap();

    public boolean refresh(Web3j web3j, Accounts list) throws IOException {
        this.AccountLists.clear();
        HashSet<String> set = new HashSet<String>();
        for (KlayCredentials klayCredentials : list.getList()) {
            set.add(klayCredentials.getAddress());
        }
        for (String string : set) {
            JSONObject jsonKey;
            KlayGetAccount acc = ((EthGetAccountResponse)web3j.klayGetAccount(string, DefaultBlockParameterName.LATEST).send()).getResult();
            if (acc == null) {
                KlayCredentials credentials = list.credentialsByAddress(string).get(0);
                if (credentials.isDeCoupled()) continue;
                jsonKey = new JSONObject();
                jsonKey.put("keyType", 1);
                jsonKey.put("key", (Object)new JSONObject());
                JSONObject jsonAccount = new JSONObject();
                jsonAccount.put("key", (Object)jsonKey);
                AccountInfo accountInfo = new AccountInfo(string, jsonAccount);
                this.AccountLists.put(string, accountInfo);
                continue;
            }
            JSONObject jsonAccount = new JSONObject((Object)acc.getAccount());
            jsonKey = AccountInfo.getKeyJSON(jsonAccount.getJSONObject("key"), list);
            if (jsonKey == null) continue;
            AccountInfo accountInfo = new AccountInfo(string, acc.getAccount().getBalance(), acc.getAccount().getNonce(), jsonKey);
            this.AccountLists.put(string, accountInfo);
        }
        return true;
    }

    public int getType(String address) {
        AccountInfo accountInfo = this.AccountLists.get(address);
        return accountInfo.getKeyType();
    }

    public JSONObject getAccountInfo(String address) throws JsonProcessingException {
        AccountInfo account = this.AccountLists.get(address);
        if (account == null) {
            return new JSONObject();
        }
        return account.getByJSON();
    }

    public JSONArray getAccountInfos() {
        JSONArray jsonArray = new JSONArray();
        for (String key : this.AccountLists.keySet()) {
            jsonArray.put((Object)this.AccountLists.get(key).getByJSON());
        }
        return jsonArray;
    }

    public boolean isInAccountStore(String address) {
        return this.AccountLists.containsKey(address);
    }
}

