/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegate;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.KlayTransactionUtils;
import org.web3j.utils.Numeric;

public class TxTypeFeeDelegatedChainDataAnchoring
extends TxTypeFeeDelegate {
    private final byte[] anchoredData;

    protected TxTypeFeeDelegatedChainDataAnchoring(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData) {
        super(type, nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.anchoredData = anchoredData;
    }

    public static TxTypeFeeDelegatedChainDataAnchoring createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData) {
        return new TxTypeFeeDelegatedChainDataAnchoring(type, nonce, gasPrice, gasLimit, from, anchoredData);
    }

    protected TxTypeFeeDelegatedChainDataAnchoring(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData) {
        super(chainId, type, nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.anchoredData = anchoredData;
    }

    public static TxTypeFeeDelegatedChainDataAnchoring createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData) {
        return new TxTypeFeeDelegatedChainDataAnchoring(chainId, type, nonce, gasPrice, gasLimit, from, anchoredData);
    }

    public byte[] getAnchoredData() {
        return this.anchoredData;
    }

    @Override
    public List<RlpType> rlpValues() {
        List<RlpType> values = super.rlpValues();
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        values.add((RlpType)RlpString.create((byte[])this.getAnchoredData()));
        return values;
    }

    @Override
    public TxType.Type getKlayType() {
        return TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING;
    }

    public static TxTypeFeeDelegatedChainDataAnchoring decodeFromRawTransaction(byte[] rawTransaction) {
        byte[] rawTransactionExceptType = KlayTransactionUtils.getRawTransactionNoType(rawTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])rawTransactionExceptType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
        String from = ((RlpString)values.get(3)).asString();
        byte[] payload = ((RlpString)values.get(4)).getBytes();
        TxType.Type type = TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING;
        TxTypeFeeDelegatedChainDataAnchoring tx = new TxTypeFeeDelegatedChainDataAnchoring(type, nonce, gasPrice, gasLimit, from, payload);
        tx.addSignatureData(values, 5);
        return tx;
    }

    public static TxTypeFeeDelegatedChainDataAnchoring decodeFromRawTransaction(String rawTransaction) {
        return TxTypeFeeDelegatedChainDataAnchoring.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        return null;
    }

    public String getData() {
        return null;
    }

    public TransactionType getType() {
        return null;
    }
}

