/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import org.web3j.crypto.Credentials;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.transaction.fee.FeePayer;
import org.web3j.crypto.transaction.type.AbstractTxType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeAccountUpdate;
import org.web3j.crypto.transaction.type.TxTypeCancel;
import org.web3j.crypto.transaction.type.TxTypeChainDataAnchoring;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegate;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedCancel;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedCancelWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedChainDataAnchoring;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedChainDataAnchoringWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractDeploy;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractDeployWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractExecution;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractExecutionWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransfer;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferMemo;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferMemoWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferWithRatio;
import org.web3j.crypto.transaction.type.TxTypeSmartContractDeploy;
import org.web3j.crypto.transaction.type.TxTypeSmartContractExecution;
import org.web3j.crypto.transaction.type.TxTypeValueTransfer;
import org.web3j.crypto.transaction.type.TxTypeValueTransferMemo;
import org.web3j.utils.KlayTransactionUtils;

public class KlayTransactionEncoder
extends TransactionEncoder {
    public static byte[] signMessage(RawTransaction rawTransaction, long chainId, KlayCredentials credentials) {
        if (credentials.isDeCoupled()) {
            throw new Error("a legacy transaction must be with a legacy account key");
        }
        return KlayTransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)chainId, (Credentials)credentials.convertToCredentials());
    }

    public static byte[] signMessage(RawTransaction rawTransaction, KlayCredentials credentials) {
        if (credentials.isDeCoupled()) {
            throw new Error("a legacy transaction must be with a legacy account key");
        }
        return KlayTransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credentials.convertToCredentials());
    }

    public static byte[] signMessage(KlayRawTransaction rawTransaction, KlayCredentials credentials) {
        AbstractTxType tx = (AbstractTxType)rawTransaction.getTransaction();
        long chainId = tx.getChainId();
        if (TxType.Type.isFeeDelegated(tx.getKlayType()) || TxType.Type.isPartialFeeDelegated(tx.getKlayType())) {
            TxTypeFeeDelegate senderTx = (TxTypeFeeDelegate)rawTransaction.getTransaction();
            return senderTx.sign(credentials, chainId).getRaw();
        }
        return tx.sign(credentials, chainId).getRaw();
    }

    public static byte[] signMessage(KlayRawTransaction rawTransaction, long chainId, KlayCredentials credentials) {
        AbstractTxType tx = (AbstractTxType)rawTransaction.getTransaction();
        if (TxType.Type.isFeeDelegated(tx.getKlayType()) || TxType.Type.isPartialFeeDelegated(tx.getKlayType())) {
            TxTypeFeeDelegate senderTx = (TxTypeFeeDelegate)rawTransaction.getTransaction();
            return senderTx.sign(credentials, chainId).getRaw();
        }
        return tx.sign(credentials, chainId).getRaw();
    }

    public static byte[] signMessageAsFeePayer(KlayRawTransaction rawTransaction, long chainId, KlayCredentials credentials) {
        TxTypeFeeDelegate senderTx = (TxTypeFeeDelegate)rawTransaction.getTransaction();
        senderTx.setFeePayer(credentials.getAddress());
        KlayRawTransaction payerTx = new FeePayer(credentials, chainId).sign(senderTx);
        return payerTx.getRaw();
    }

    public static byte[] signMessageAsFeePayer(KlayRawTransaction rawTransaction, KlayCredentials credentials) {
        TxTypeFeeDelegate senderTx = (TxTypeFeeDelegate)rawTransaction.getTransaction();
        long chainId = senderTx.getChainId();
        senderTx.setFeePayer(credentials.getAddress());
        KlayRawTransaction payerTx = new FeePayer(credentials, chainId).sign(senderTx);
        return payerTx.getRaw();
    }

    public static byte[] signMessage(byte[] encodedSenderTransaction, long chainId, KlayCredentials credentials) {
        TxType.Type type = KlayTransactionUtils.getType(encodedSenderTransaction);
        if (!TxType.Type.isFeeDelegated(type) && !TxType.Type.isPartialFeeDelegated(type)) {
            return (switch (type) {
                case TxType.Type.ACCOUNT_UPDATE -> TxTypeAccountUpdate.decodeFromRawTransaction(encodedSenderTransaction);
                case TxType.Type.CANCEL -> TxTypeCancel.decodeFromRawTransaction(encodedSenderTransaction);
                case TxType.Type.SMART_CONTRACT_DEPLOY -> TxTypeSmartContractDeploy.decodeFromRawTransaction(encodedSenderTransaction);
                case TxType.Type.SMART_CONTRACT_EXECUTION -> TxTypeSmartContractExecution.decodeFromRawTransaction(encodedSenderTransaction);
                case TxType.Type.VALUE_TRANSFER -> TxTypeValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
                case TxType.Type.VALUE_TRANSFER_MEMO -> TxTypeValueTransferMemo.decodeFromRawTransaction(encodedSenderTransaction);
                case TxType.Type.CHAIN_DATA_ANCHORING -> TxTypeChainDataAnchoring.decodeFromRawTransaction(encodedSenderTransaction);
                default -> TxTypeValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
            }).sign(credentials, chainId).getRaw();
        }
        return (switch (type) {
            case TxType.Type.FEE_DELEGATED_CANCEL -> TxTypeFeeDelegatedCancel.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_CANCEL_WITH_RATIO -> TxTypeFeeDelegatedCancelWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY -> TxTypeFeeDelegatedSmartContractDeploy.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO -> TxTypeFeeDelegatedSmartContractDeployWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION -> TxTypeFeeDelegatedSmartContractExecution.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO -> TxTypeFeeDelegatedSmartContractExecutionWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_VALUE_TRANSFER -> TxTypeFeeDelegatedValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO -> TxTypeFeeDelegatedValueTransferMemo.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO -> TxTypeFeeDelegatedValueTransferWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO -> TxTypeFeeDelegatedValueTransferMemoWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO -> TxTypeFeeDelegatedChainDataAnchoringWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING -> TxTypeFeeDelegatedChainDataAnchoring.decodeFromRawTransaction(encodedSenderTransaction);
            default -> TxTypeFeeDelegatedValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
        }).sign(credentials, chainId).getRaw();
    }

    public static byte[] signMessageAsFeePayer(byte[] encodedSenderTransaction, long chainId, KlayCredentials credentials) {
        TxType.Type type = KlayTransactionUtils.getType(encodedSenderTransaction);
        KlayRawTransaction payerTx = new FeePayer(credentials, chainId).sign(switch (type) {
            case TxType.Type.FEE_DELEGATED_CANCEL -> TxTypeFeeDelegatedCancel.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_CANCEL_WITH_RATIO -> TxTypeFeeDelegatedCancelWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY -> TxTypeFeeDelegatedSmartContractDeploy.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO -> TxTypeFeeDelegatedSmartContractDeployWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION -> TxTypeFeeDelegatedSmartContractExecution.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO -> TxTypeFeeDelegatedSmartContractExecutionWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_VALUE_TRANSFER -> TxTypeFeeDelegatedValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO -> TxTypeFeeDelegatedValueTransferMemo.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO -> TxTypeFeeDelegatedValueTransferWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO -> TxTypeFeeDelegatedValueTransferMemoWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING -> TxTypeFeeDelegatedChainDataAnchoring.decodeFromRawTransaction(encodedSenderTransaction);
            case TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO -> TxTypeFeeDelegatedChainDataAnchoringWithRatio.decodeFromRawTransaction(encodedSenderTransaction);
            default -> TxTypeFeeDelegatedValueTransfer.decodeFromRawTransaction(encodedSenderTransaction);
        });
        return payerTx.getRaw();
    }
}

