/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.tooling.abi;

import foundation.icon.ee.struct.Member;
import foundation.icon.ee.struct.PropertyMember;
import foundation.icon.ee.struct.StructDB;
import foundation.icon.ee.tooling.abi.ABICompilerClassVisitor;
import foundation.icon.ee.tooling.abi.ABICompilerException;
import foundation.icon.ee.tooling.abi.KeptMemberCollector;
import foundation.icon.ee.types.Method;
import foundation.icon.ee.util.ASM;
import foundation.icon.ee.util.Multimap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import org.aion.avm.tooling.deploy.eliminator.ParameterNameRemover;
import org.aion.avm.utilities.JarBuilder;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public class ABICompiler {
    private String mainClassName;
    private byte[] mainClassBytes;
    private byte[] outputJarFile;
    private List<Method> callables;
    private Map<String, byte[]> classMap = new HashMap<String, byte[]>();
    private boolean stripLineNumber;
    private final Set<String> rootClasses = new HashSet<String>();
    private final Map<String, List<Member>> keptMethods = new HashMap<String, List<Member>>();
    private final Map<String, List<Member>> keptFields = new HashMap<String, List<Member>>();

    public static ABICompiler compileJar(InputStream byteReader, boolean stripLineNumber) {
        return ABICompiler.initCompilerAndCompile(byteReader, stripLineNumber);
    }

    public static ABICompiler compileJarBytes(byte[] rawBytes, boolean stripLineNumber) {
        return ABICompiler.initCompilerAndCompile(new ByteArrayInputStream(rawBytes), stripLineNumber);
    }

    private static ABICompiler initCompilerAndCompile(InputStream byteReader, boolean stripLineNumber) {
        ABICompiler compiler = new ABICompiler();
        compiler.stripLineNumber = stripLineNumber;
        compiler.compile(byteReader);
        return compiler;
    }

    private ABICompiler() {
    }

    private static void addKeptProperty(Map<String, List<Member>> map, PropertyMember p) {
        Multimap.add(map, (Object)p.getDeclaringType().getInternalName(), (Object)p.getMember());
    }

    private void collectKeptProperties(List<PropertyMember> props) {
        block4: for (PropertyMember p : props) {
            switch (p.getSort()) {
                case 0: {
                    ABICompiler.addKeptProperty(this.keptFields, p);
                    continue block4;
                }
                case 1: 
                case 2: {
                    ABICompiler.addKeptProperty(this.keptMethods, p);
                    continue block4;
                }
            }
            assert (false);
        }
    }

    private void compile(InputStream byteReader) {
        try {
            this.safeLoadFromBytes(byteReader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StructDB structDB = new StructDB(this.classMap, true);
        ClassWriter cw = new ClassWriter(1);
        ABICompilerClassVisitor cv = new ABICompilerClassVisitor(cw, this.classMap, structDB, this.stripLineNumber);
        ASM.accept((byte[])this.mainClassBytes, (ClassVisitor)cv);
        this.callables = cv.getCallableInfo();
        this.mainClassBytes = cw.toByteArray();
        this.classMap.put(this.mainClassName, this.mainClassBytes);
        this.rootClasses.add(this.mainClassName);
        String internalName = Utilities.fullyQualifiedNameToInternalName((String)this.mainClassName);
        for (Method method : this.callables) {
            Multimap.add(this.keptMethods, (Object)internalName, (Object)new Member(method.getName(), method.getDescriptor()));
        }
        Set paramStructs = structDB.getParameterStructs();
        for (Type s : paramStructs) {
            this.rootClasses.add(s.getClassName());
            Multimap.add(this.keptMethods, (Object)s.getInternalName(), (Object)new Member("<init>", "()V"));
            this.collectKeptProperties(structDB.getWritableProperties(s));
        }
        Set set = structDB.getReturnStructs();
        for (Type type : set) {
            this.rootClasses.add(type.getClassName());
            this.collectKeptProperties(structDB.getReadableProperties(type));
        }
        for (Map.Entry entry : this.classMap.entrySet()) {
            ClassWriter icw = new ClassWriter(1);
            KeptMemberCollector icv = (KeptMemberCollector)ASM.accept((byte[])((byte[])entry.getValue()), (ClassVisitor)new KeptMemberCollector(new ParameterNameRemover((ClassVisitor)icw)));
            String name = Utilities.fullyQualifiedNameToInternalName((String)((String)entry.getKey()));
            Multimap.addAll(this.keptMethods, (Object)name, icv.getKeptMethods());
            Multimap.addAll(this.keptFields, (Object)name, icv.getKeptFields());
            this.classMap.put((String)entry.getKey(), icw.toByteArray());
        }
        this.outputJarFile = JarBuilder.buildJarForExplicitClassNamesAndBytecode((String)this.mainClassName, this.classMap, (Class[])new Class[0]);
    }

    private void safeLoadFromBytes(InputStream byteReader) throws Exception {
        JarInputStream jarReader = new JarInputStream(byteReader, true);
        this.classMap = Utilities.extractClasses((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
        this.mainClassName = Utilities.extractMainClassName((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
        this.mainClassBytes = this.classMap.get(this.mainClassName);
        if (this.mainClassBytes == null) {
            throw new ABICompilerException("Cannot find main class: " + this.mainClassName);
        }
    }

    public List<Method> getCallables() {
        return this.callables;
    }

    public byte[] getJarFileBytes() {
        return this.outputJarFile;
    }

    public Set<String> getRootClasses() {
        return this.rootClasses;
    }

    public Map<String, List<Member>> getKeptMethods() {
        return this.keptMethods;
    }

    public Map<String, List<Member>> getKeptFields() {
        return this.keptFields;
    }
}

