/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.eliminator;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aion.avm.tooling.deploy.eliminator.MethodInfo;

public class ClassInfo {
    private final String className;
    private final Map<String, MethodInfo> methodMap;
    private final List<MethodInfo> alwaysReachables;
    private final Set<ClassInfo> parents = new HashSet<ClassInfo>();
    private final Set<ClassInfo> children = new HashSet<ClassInfo>();
    private ClassInfo superInfo;
    private final boolean isInterface;
    private final boolean isAbstract;
    private final boolean isSystemClass;

    public ClassInfo(String className, boolean isInterface, boolean isAbstract, Map<String, MethodInfo> methodMap, List<MethodInfo> alwaysReachables) {
        this.className = className;
        this.isInterface = isInterface;
        this.isAbstract = isAbstract;
        this.methodMap = methodMap;
        this.alwaysReachables = alwaysReachables;
        this.isSystemClass = false;
    }

    public ClassInfo(String className, Map<String, MethodInfo> methodMap, int modifiers) {
        this.className = className;
        this.methodMap = methodMap;
        this.isInterface = Modifier.isInterface(modifiers);
        this.isAbstract = Modifier.isAbstract(modifiers) && !this.isInterface;
        this.alwaysReachables = new ArrayList<MethodInfo>();
        this.isSystemClass = true;
    }

    public void setSuperclass(ClassInfo superInfo) {
        this.superInfo = superInfo;
        this.addToParents(superInfo);
    }

    public ClassInfo getSuperclass() {
        return this.superInfo;
    }

    public MethodInfo getDeclaration(String methodId) {
        MethodInfo methodInfo = this.getConcreteImplementation(methodId);
        Iterator<ClassInfo> iterator = this.parents.iterator();
        while (iterator.hasNext() && null == methodInfo) {
            ClassInfo parentInfo = iterator.next();
            if (!parentInfo.isInterface()) continue;
            methodInfo = parentInfo.getMethodMap().get(methodId);
        }
        return methodInfo;
    }

    public MethodInfo getConcreteImplementation(String methodId) {
        MethodInfo methodInfo = this.methodMap.get(methodId);
        if (null == methodInfo && null != this.superInfo) {
            methodInfo = this.superInfo.getConcreteImplementation(methodId);
        }
        return methodInfo;
    }

    public void addToParents(ClassInfo parent) {
        this.parents.add(parent);
        this.parents.addAll(parent.parents);
        for (ClassInfo childClassInfo : this.children) {
            childClassInfo.addToParents(parent);
        }
    }

    public void addToChildren(ClassInfo child) {
        this.children.add(child);
        this.children.addAll(child.children);
        for (ClassInfo parentsClassInfo : this.parents) {
            parentsClassInfo.addToChildren(child);
        }
    }

    public Map<String, MethodInfo> getMethodMap() {
        return this.methodMap;
    }

    public String getClassName() {
        return this.className;
    }

    public List<MethodInfo> getAlwaysReachables() {
        return this.alwaysReachables;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isSystemClass() {
        return this.isSystemClass;
    }

    public Set<ClassInfo> getParents() {
        return this.parents;
    }

    public Set<ClassInfo> getChildren() {
        return this.children;
    }
}

