/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.tooling.abi;

import foundation.icon.ee.struct.StructDB;
import foundation.icon.ee.tooling.abi.ABICompilerException;
import foundation.icon.ee.tooling.abi.ABICompilerFieldVisitor;
import foundation.icon.ee.tooling.abi.ABICompilerMethodVisitor;
import foundation.icon.ee.types.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ABICompilerClassVisitor
extends ClassVisitor {
    private final List<ABICompilerMethodVisitor> methodVisitors = new ArrayList<ABICompilerMethodVisitor>();
    private List<Method> callableInfo = new ArrayList<Method>();
    private final Map<String, byte[]> classMap;
    private final StructDB structDB;
    private final boolean stripLineNumber;

    public ABICompilerClassVisitor(ClassWriter cw, Map<String, byte[]> classMap, StructDB structDB, boolean stripLineNumber) {
        super(458752, (ClassVisitor)cw);
        this.classMap = classMap;
        this.structDB = structDB;
        this.stripLineNumber = stripLineNumber;
    }

    public List<Method> getCallableInfo() {
        return this.callableInfo;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null && !superName.equals("java/lang/Object")) {
            String superClassName = Utilities.internalNameToFullyQualifiedName((String)superName);
            byte[] classBytes = this.classMap.get(superClassName);
            if (classBytes == null) {
                throw new ABICompilerException("Cannot find super class: " + superName);
            }
            ClassReader reader = new ClassReader(classBytes);
            ClassWriter classWriter = new ClassWriter(1);
            ABICompilerClassVisitor superVisitor = new ABICompilerClassVisitor(classWriter, this.classMap, this.structDB, this.stripLineNumber);
            reader.accept((ClassVisitor)superVisitor, 0);
            this.callableInfo = superVisitor.getCallableInfo();
            classBytes = classWriter.toByteArray();
            this.classMap.replace(superClassName, classBytes);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return new ABICompilerFieldVisitor(access, name, descriptor, super.visitField(access, name, descriptor, signature, value));
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (name.equals("main") && (access & 1) != 0) {
            throw new ABICompilerException("main method cannot be defined", name);
        }
        ABICompilerMethodVisitor mv = new ABICompilerMethodVisitor(access, name, descriptor, super.visitMethod(access, name, descriptor, signature, exceptions), this.structDB, this.stripLineNumber);
        this.methodVisitors.add(mv);
        return mv;
    }

    public void visitEnd() {
        this.postProcess();
        super.visitEnd();
    }

    private void postProcess() {
        boolean foundOnInstall = false;
        HashSet<String> currentCallables = new HashSet<String>();
        HashSet<String> currentEvents = new HashSet<String>();
        Set superCallables = this.callableInfo.stream().filter(m -> m.getType() == 0 || m.getType() == 1).map(Method::getName).collect(Collectors.toSet());
        Set superEvents = this.callableInfo.stream().filter(m -> m.getType() == 2).map(Method::getName).collect(Collectors.toSet());
        for (ABICompilerMethodVisitor mv : this.methodVisitors) {
            Method mth;
            String methodName = mv.getMethodName();
            if (mv.isExternal()) {
                if (currentCallables.contains(methodName)) {
                    throw new ABICompilerException("Multiple @External methods with the same name", methodName);
                }
                currentCallables.add(methodName);
                if (superCallables.contains(methodName)) {
                    mth = this.callableInfo.stream().filter(m -> m.getName().equals(methodName)).findFirst().orElse(null);
                    if (mth != null && !mth.equals((Object)mv.getCallableMethodInfo())) {
                        throw new ABICompilerException("Re-define a @External method with a different flag", methodName);
                    }
                    this.callableInfo.remove(mth);
                }
                this.callableInfo.add(mv.getCallableMethodInfo());
                continue;
            }
            if (mv.isOnInstall()) {
                if (foundOnInstall) {
                    throw new ABICompilerException("Multiple public <init> methods", methodName);
                }
                foundOnInstall = true;
                this.callableInfo.removeIf(m -> m.getName().equals(methodName));
                this.callableInfo.add(mv.getCallableMethodInfo());
                continue;
            }
            if (mv.isEventLog()) {
                if (currentEvents.contains(methodName)) {
                    throw new ABICompilerException("Multiple @EventLog methods with the same name", methodName);
                }
                currentEvents.add(methodName);
                if (superEvents.contains(methodName)) {
                    mth = this.callableInfo.stream().filter(m -> m.getName().equals(methodName)).findFirst().orElse(null);
                    if (mth != null && mth.getIndexed() != mv.getCallableMethodInfo().getIndexed()) {
                        throw new ABICompilerException("Re-define a @EventLog method with a different indexed", methodName);
                    }
                    this.callableInfo.remove(mth);
                }
                this.callableInfo.add(mv.getCallableMethodInfo());
                continue;
            }
            if (mv.isFallback()) {
                if (mv.isPayable()) {
                    this.callableInfo.removeIf(m -> m.getName().equals(methodName));
                    this.callableInfo.add(mv.getCallableMethodInfo());
                    continue;
                }
                if (!superCallables.contains(methodName)) continue;
                throw new ABICompilerException("Invalid fallback method re-definition", methodName);
            }
            if (!superCallables.contains(methodName) && !superEvents.contains(methodName)) continue;
            throw new ABICompilerException("Re-define a method without annotation", methodName);
        }
    }
}

