/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.eliminator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aion.avm.tooling.deploy.eliminator.MethodDependencyVisitor;
import org.aion.avm.tooling.deploy.eliminator.MethodInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassDependencyVisitor
extends ClassVisitor {
    private final String classSlashName;
    private String superSlashName;
    private String[] interfaces;
    private final List<MethodDependencyVisitor> methodVisitors = new ArrayList<MethodDependencyVisitor>();
    private final Map<String, MethodInfo> methodMap = new HashMap<String, MethodInfo>();
    private final List<MethodInfo> alwaysReachables = new ArrayList<MethodInfo>();
    private boolean isInterface;
    private boolean isAbstract;

    public ClassDependencyVisitor(String classSlashName) {
        super(458752);
        this.classSlashName = classSlashName;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superSlashName = superName;
        this.interfaces = interfaces;
        this.isInterface = (access & 0x200) != 0;
        this.isAbstract = (access & 0x400) != 0;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodDependencyVisitor mv = new MethodDependencyVisitor(name, descriptor, access, super.visitMethod(access, name, descriptor, signature, exceptions));
        this.methodVisitors.add(mv);
        return mv;
    }

    public void visitEnd() {
        for (MethodDependencyVisitor methodVisitor : this.methodVisitors) {
            MethodInfo methodInfo = new MethodInfo(methodVisitor.getMethodIdentifier(), methodVisitor.isStatic(), methodVisitor.getMethodsCalled());
            this.methodMap.put(methodVisitor.getMethodIdentifier(), methodInfo);
            if (!this.isAlwaysReachable(methodInfo.methodIdentifier) && !this.isIOMethod(methodInfo)) continue;
            methodInfo.isReachable = true;
            this.alwaysReachables.add(methodInfo);
        }
        super.visitEnd();
    }

    private boolean isIOMethod(MethodInfo info) {
        String name = info.methodIdentifier;
        if (!info.isStatic) {
            return false;
        }
        return name.equals("readObject(Lscore/ObjectReader;)L" + this.classSlashName + ";") || name.equals("writeObject(Lscore/ObjectWriter;L" + this.classSlashName + ";)V");
    }

    private boolean isAlwaysReachable(String name) {
        return name.equals("<clinit>()V") || name.equals("hashCode()I") || name.equals("toString()Ljava/lang/String;") || name.equals("equals(Ljava/lang/Object;)Z") || name.equals("getCode()I");
    }

    public String getClassSlashName() {
        return this.classSlashName;
    }

    public String getSuperSlashName() {
        return this.superSlashName;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public Map<String, MethodInfo> getMethodMap() {
        return this.methodMap;
    }

    public List<MethodInfo> getAlwaysReachables() {
        return this.alwaysReachables;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }
}

