/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.eliminator;

import java.util.HashMap;
import java.util.Map;
import org.aion.avm.core.util.AllowlistProvider;
import org.aion.avm.tooling.deploy.eliminator.ClassInfo;
import org.aion.avm.tooling.deploy.eliminator.MethodInfo;
import org.aion.avm.utilities.Utilities;

public class AllowlistPopulator {
    public static Map<String, ClassInfo> getClassInfoMap() {
        HashMap<String, ClassInfo> classInfoMap = new HashMap<String, ClassInfo>();
        try {
            Map allowlist = AllowlistProvider.getClassLibraryMap();
            allowlist.forEach((clazz, methodDescriptors) -> {
                HashMap<String, MethodInfo> methodMap = new HashMap<String, MethodInfo>();
                methodDescriptors.forEach(md -> {
                    String methodName = md.name + md.parameters;
                    methodMap.put(methodName, new MethodInfo(methodName, md.isStatic));
                });
                String className = Utilities.fullyQualifiedNameToInternalName((String)clazz.getName());
                ClassInfo ci = new ClassInfo(className, methodMap, clazz.getModifiers());
                classInfoMap.put(className, ci);
            });
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        ClassInfo comparableInfo = (ClassInfo)classInfoMap.get("java/lang/Comparable");
        ClassInfo iterableInfo = (ClassInfo)classInfoMap.get("java/lang/Iterable");
        ClassInfo serializableInfo = (ClassInfo)classInfoMap.get("java/io/Serializable");
        ClassInfo throwableInfo = (ClassInfo)classInfoMap.get("java/lang/Throwable");
        ClassInfo exceptionInfo = (ClassInfo)classInfoMap.get("java/lang/Exception");
        ClassInfo runtimeExceptionInfo = (ClassInfo)classInfoMap.get("java/lang/RuntimeException");
        ClassInfo enumInfo = (ClassInfo)classInfoMap.get("java/lang/Enum");
        ClassInfo collectionInfo = (ClassInfo)classInfoMap.get("java/util/Collection");
        ClassInfo setInfo = (ClassInfo)classInfoMap.get("java/util/Set");
        ClassInfo listInfo = (ClassInfo)classInfoMap.get("java/util/List");
        ClassInfo iteratorInfo = (ClassInfo)classInfoMap.get("java/util/Iterator");
        ClassInfo listIteratorInfo = (ClassInfo)classInfoMap.get("java/util/ListIterator");
        collectionInfo.addToParents(iterableInfo);
        setInfo.addToParents(collectionInfo);
        throwableInfo.addToParents(serializableInfo);
        exceptionInfo.setSuperclass(throwableInfo);
        enumInfo.addToParents(comparableInfo);
        enumInfo.addToParents(serializableInfo);
        listIteratorInfo.addToParents(iteratorInfo);
        runtimeExceptionInfo.setSuperclass(exceptionInfo);
        listInfo.addToParents(collectionInfo);
        return classInfoMap;
    }
}

