/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.renamer;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.aion.avm.tooling.deploy.eliminator.ClassInfo;
import org.aion.avm.tooling.deploy.eliminator.MethodReachabilityDetector;
import org.aion.avm.tooling.deploy.renamer.ClassRenamer;
import org.aion.avm.tooling.deploy.renamer.FieldRenamer;
import org.aion.avm.tooling.deploy.renamer.MethodRenamer;
import org.aion.avm.utilities.JarBuilder;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.ClassNode;

public class Renamer {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Input the path to the jar file.");
            System.exit(0);
        }
        String[] roots = Arrays.copyOfRange(args, 1, args.length);
        try (FileInputStream fileInputStream = new FileInputStream(args[0]);){
            byte[] renamedJarBytes = Renamer.rename(fileInputStream.readAllBytes(), roots);
            int pathLength = args[0].lastIndexOf("/") + 1;
            String outputJarName = args[0].substring(0, pathLength) + "renamed_" + args[0].substring(pathLength);
            Renamer.writeOptimizedJar(outputJarName, renamedJarBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static byte[] rename(byte[] jarBytes, String[] roots) throws Exception {
        JarInputStream jarReader = new JarInputStream((InputStream)new ByteArrayInputStream(jarBytes), true);
        String mainClassName = Utilities.extractMainClassName((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.SLASH_NAME);
        Map<String, ClassNode> sortedClassMap = Renamer.sortBasedOnInnerClassLevel(Renamer.extractClasses(jarReader));
        String[] newMainNameBuf = new String[1];
        Map<String, ClassNode> renamedNodes = Renamer.renameClassNodes(sortedClassMap, mainClassName, roots, newMainNameBuf);
        Map<String, byte[]> classNameByteCodeMap = Renamer.getClassBytes(renamedNodes);
        String newMainClassName = newMainNameBuf[0];
        byte[] mainClassBytes = classNameByteCodeMap.get(newMainClassName);
        classNameByteCodeMap.remove(newMainClassName, mainClassBytes);
        return JarBuilder.buildJarForExplicitClassNamesAndBytecode((String)Utilities.internalNameToFullyQualifiedName((String)newMainClassName), (byte[])mainClassBytes, classNameByteCodeMap, (Class[])new Class[0]);
    }

    public static Map<String, ClassNode> sortBasedOnInnerClassLevel(Map<String, ClassNode> classMap) {
        Comparator keyComparator = (n1, n2) -> Long.compare(((String)n1.getKey()).chars().filter(ch -> ch == 36).count(), ((String)n2.getKey()).chars().filter(ch -> ch == 36).count());
        return classMap.entrySet().stream().sorted(keyComparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static Map<String, ClassNode> renameClassNodes(Map<String, ClassNode> sortedClassMap, String mainClassName, String[] roots, String[] out_newMainName) throws Exception {
        Map<String, String> mappedNames = ClassRenamer.renameClasses(sortedClassMap);
        if (out_newMainName != null && out_newMainName.length > 0) {
            out_newMainName[0] = mappedNames.get(mainClassName);
        }
        Map<String, ClassNode> newClassNameMap = Renamer.applyMapping(sortedClassMap, mappedNames);
        String newMainClassName = mappedNames.get(mainClassName);
        Map<String, ClassInfo> classInfoMap = MethodReachabilityDetector.getClassInfoMap(newMainClassName, Renamer.getClassBytes(newClassNameMap), roots);
        mappedNames = MethodRenamer.renameMethods(newClassNameMap, classInfoMap, newMainClassName, roots);
        Map<String, ClassNode> newMethodNameMap = Renamer.applyMapping(newClassNameMap, mappedNames);
        mappedNames = FieldRenamer.renameFields(newMethodNameMap, classInfoMap);
        return Renamer.applyMapping(newMethodNameMap, mappedNames);
    }

    private static Map<String, ClassNode> applyMapping(Map<String, ClassNode> classMap, Map<String, String> classNameMap) {
        SimpleRemapper remapper = new SimpleRemapper(classNameMap);
        HashMap<String, ClassNode> newClassMap = new HashMap<String, ClassNode>();
        for (ClassNode node : classMap.values()) {
            ClassNode copy = new ClassNode();
            ClassRemapper adapter = new ClassRemapper((ClassVisitor)copy, (Remapper)remapper);
            node.accept((ClassVisitor)adapter);
            newClassMap.put(copy.name, copy);
        }
        return newClassMap;
    }

    public static Map<String, ClassNode> extractClasses(JarInputStream jarReader) throws IOException {
        HashMap<String, ClassNode> classMap = new HashMap<String, ClassNode>();
        Map classByteMap = Utilities.extractClasses((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.SLASH_NAME);
        classByteMap.forEach((key, value) -> {
            ClassNode c = new ClassNode();
            new ClassReader(value).accept((ClassVisitor)c, 0);
            classMap.put((String)key, c);
        });
        return classMap;
    }

    private static Map<String, byte[]> getClassBytes(Map<String, ClassNode> classMap) {
        HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>();
        for (ClassNode node : classMap.values()) {
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            byte[] classBytes = writer.toByteArray();
            byteMap.put(node.name, classBytes);
        }
        return byteMap;
    }

    private static void writeOptimizedJar(String jarName, byte[] jarBytes) {
        try {
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(jarName));
            dout.write(jarBytes);
            dout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Successfully created jar. \n" + jarName);
    }
}

