/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.tooling.deploy;

import foundation.icon.ee.tooling.abi.ABICompiler;
import foundation.icon.ee.types.Method;
import foundation.icon.ee.util.MethodPacker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import org.aion.avm.tooling.deploy.JarOptimizer;
import org.aion.avm.tooling.deploy.eliminator.UnreachableMethodRemover;
import org.aion.avm.tooling.deploy.renamer.Renamer;
import org.aion.avm.utilities.JarBuilder;
import org.aion.avm.utilities.Utilities;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;

public class OptimizedJarBuilder {
    private final boolean debugModeEnabled;
    private boolean unreachableMethodRemoverEnabled;
    private boolean classAndFieldRenamerEnabled;
    private final byte[] dappBytes;
    private final List<Method> callables;

    public OptimizedJarBuilder(boolean debugModeEnabled, byte[] jarBytes) {
        this(debugModeEnabled, jarBytes, false);
    }

    public OptimizedJarBuilder(boolean debugModeEnabled, byte[] jarBytes, boolean stripLineNumber) {
        this.debugModeEnabled = debugModeEnabled;
        ABICompiler compiler = ABICompiler.compileJarBytes(jarBytes, stripLineNumber);
        this.dappBytes = compiler.getJarFileBytes();
        this.callables = compiler.getCallables();
    }

    public OptimizedJarBuilder withUnreachableMethodRemover() {
        this.unreachableMethodRemoverEnabled = true;
        return this;
    }

    public OptimizedJarBuilder withRenamer() {
        this.classAndFieldRenamerEnabled = true;
        return this;
    }

    public byte[] getOptimizedBytes() {
        JarOptimizer jarOptimizer = new JarOptimizer(this.debugModeEnabled);
        byte[] optimizedDappBytes = jarOptimizer.optimize(this.dappBytes);
        String[] roots = new String[this.callables.size()];
        for (int i = 0; i < roots.length; ++i) {
            Method c = this.callables.get(i);
            roots[i] = c.getName() + c.getDescriptor();
        }
        if (this.unreachableMethodRemoverEnabled) {
            try {
                optimizedDappBytes = UnreachableMethodRemover.optimize(optimizedDappBytes, roots);
                optimizedDappBytes = jarOptimizer.optimize(optimizedDappBytes);
            }
            catch (UnsupportedOperationException ex) {
                throw ex;
            }
            catch (Exception exception) {
                System.err.println("UnreachableMethodRemover failed, packaging code without this optimization");
                exception.printStackTrace(System.err);
            }
        }
        if (this.classAndFieldRenamerEnabled && !this.debugModeEnabled) {
            try {
                optimizedDappBytes = Renamer.rename(optimizedDappBytes, roots);
            }
            catch (Exception exception) {
                System.err.println("Renaming failed, packaging code without this optimization");
                exception.printStackTrace(System.err);
            }
        }
        try {
            optimizedDappBytes = this.writeApi(optimizedDappBytes);
        }
        catch (Exception e) {
            System.err.println("Writing API info failed.");
            e.printStackTrace(System.err);
        }
        return optimizedDappBytes;
    }

    private byte[] writeApi(byte[] jarBytes) throws IOException {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        packer.packArrayHeader(this.callables.size());
        for (Method m : this.callables) {
            if (this.debugModeEnabled) {
                System.out.println(m);
            }
            MethodPacker.writeTo((Method)m, (MessageBufferPacker)packer, (boolean)true);
        }
        packer.close();
        JarInputStream jis = new JarInputStream((InputStream)new ByteArrayInputStream(jarBytes), true);
        Map classMap = Utilities.extractClasses((JarInputStream)jis, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
        String mainClassName = Utilities.extractMainClassName((JarInputStream)jis, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
        byte[] mainClassBytes = (byte[])classMap.remove(mainClassName);
        return JarBuilder.buildJarWithApiInfo((String)mainClassName, (byte[])mainClassBytes, (byte[])packer.toByteArray(), (Map)classMap);
    }
}

