/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.renamer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aion.avm.tooling.deploy.eliminator.ClassInfo;
import org.aion.avm.tooling.deploy.renamer.NameGenerator;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodRenamer {
    private static final boolean printEnabled = false;
    private static final Set<String> restrictions = Set.of(new String[]{"hashCode", "equals", "<init>", "<clinit>", "toString", "readObject", "writeObject"});
    private static Set<String> jclMethods;

    public static Map<String, String> renameMethods(Map<String, ClassNode> classMap, Map<String, ClassInfo> classInfoMap, String mainClass, String[] externalMethods) {
        jclMethods = MethodRenamer.getUsedJclMethodList(classInfoMap);
        HashMap<String, String> newMethodMappingsForRemapper = new HashMap<String, String>();
        HashMap<String, String> newMethodNames = new HashMap<String, String>();
        NameGenerator generator = new NameGenerator();
        List<String> externalMethodList = Arrays.asList(externalMethods);
        for (Map.Entry<String, ClassNode> e : classMap.entrySet()) {
            String className = e.getKey();
            List methodNodes = e.getValue().methods;
            ClassInfo currentClassInfo = classInfoMap.get(className);
            for (MethodNode m : methodNodes) {
                if (className.equals(mainClass) && externalMethodList.contains(m.name + m.desc)) continue;
                if (e.getValue().superName.equals("java/lang/Enum") && (m.name.equals("values") || m.name.equals("valueOf"))) {
                    MethodRenamer.printInfo(e.getKey(), m.name, (String)newMethodMappingsForRemapper.get(MethodRenamer.makeMethodFullName(className, m)));
                    continue;
                }
                if (MethodRenamer.canBeRenamed(m) && !newMethodMappingsForRemapper.containsKey(MethodRenamer.makeMethodFullName(className, m))) {
                    String newName;
                    if (!newMethodNames.containsKey(m.name)) {
                        newName = generator.getNextMethodOrFieldName(jclMethods);
                        newMethodNames.put(m.name, newName);
                    } else {
                        newName = (String)newMethodNames.get(m.name);
                    }
                    newMethodMappingsForRemapper.put(MethodRenamer.makeMethodFullName(className, m), newName);
                    MethodRenamer.printInfo(e.getKey(), m.name, newName);
                    for (ClassInfo c : currentClassInfo.getChildren()) {
                        newMethodMappingsForRemapper.put(MethodRenamer.makeMethodFullName(c.getClassName(), m), newName);
                        MethodRenamer.printInfo(c.getClassName(), m.name, newName);
                    }
                    continue;
                }
                MethodRenamer.printInfo(e.getKey(), m.name, (String)newMethodMappingsForRemapper.get(MethodRenamer.makeMethodFullName(className, m)));
            }
        }
        return newMethodMappingsForRemapper;
    }

    private static boolean canBeRenamed(MethodNode node) {
        return !restrictions.contains(node.name) && !jclMethods.contains(node.name);
    }

    private static Set<String> getUsedJclMethodList(Map<String, ClassInfo> classInfoMap) {
        HashSet<String> jclMethods = new HashSet<String>();
        for (ClassInfo classInfo : classInfoMap.values()) {
            if (classInfo.isSystemClass()) continue;
            List parents = classInfo.getParents().stream().map(ClassInfo::getClassName).collect(Collectors.toList());
            for (String p : parents) {
                if (!classInfoMap.containsKey(p)) continue;
                jclMethods.addAll(classInfoMap.get(p).getMethodMap().keySet().stream().map(m -> m.substring(0, m.indexOf("("))).collect(Collectors.toSet()));
            }
        }
        return jclMethods;
    }

    private static String makeMethodFullName(String owner, MethodNode m) {
        return owner + "." + m.name + m.desc;
    }

    private static void printInfo(String className, String oldMethodName, String newMethodName) {
    }
}

