/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.eliminator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import org.aion.avm.tooling.deploy.eliminator.ClassInfo;
import org.aion.avm.tooling.deploy.eliminator.ClassUnreachabilityVisitor;
import org.aion.avm.tooling.deploy.eliminator.MethodReachabilityDetector;
import org.aion.avm.utilities.JarBuilder;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class UnreachableMethodRemover {
    public static byte[] optimize(byte[] jarBytes, String[] roots) throws Exception {
        HashMap<String, byte[]> outputClassMap = new HashMap<String, byte[]>();
        JarInputStream jarReader = new JarInputStream((InputStream)new ByteArrayInputStream(jarBytes), true);
        String mainClassName = Utilities.extractMainClassName((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.SLASH_NAME);
        Map inputClassMap = Utilities.extractClasses((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.SLASH_NAME);
        Map<String, ClassInfo> classInfoMap = MethodReachabilityDetector.getClassInfoMap(mainClassName, inputClassMap, roots);
        for (Map.Entry entry : inputClassMap.entrySet()) {
            ClassReader reader = new ClassReader((byte[])entry.getValue());
            ClassWriter classWriter = new ClassWriter(1);
            ClassUnreachabilityVisitor classVisitor = new ClassUnreachabilityVisitor(classWriter, classInfoMap.get(entry.getKey()).getMethodMap());
            reader.accept((ClassVisitor)classVisitor, 0);
            outputClassMap.put(Utilities.internalNameToFullyQualifiedName((String)((String)entry.getKey())), classWriter.toByteArray());
        }
        byte[] mainClassBytes = (byte[])outputClassMap.remove(Utilities.internalNameToFullyQualifiedName((String)mainClassName));
        return JarBuilder.buildJarForExplicitClassNamesAndBytecode((String)Utilities.internalNameToFullyQualifiedName((String)mainClassName), (byte[])mainClassBytes, outputClassMap, (Class[])new Class[0]);
    }
}

