/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.eliminator;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.aion.avm.tooling.deploy.eliminator.ClassInfo;
import org.aion.avm.tooling.deploy.eliminator.JarDependencyCollector;
import org.aion.avm.tooling.deploy.eliminator.MethodInfo;
import org.aion.avm.tooling.deploy.eliminator.MethodInvocation;

public class MethodReachabilityDetector {
    private final Map<String, ClassInfo> classInfoMap;
    private final Queue<MethodInfo> methodQueue;

    public static Map<String, ClassInfo> getClassInfoMap(String mainClassName, Map<String, byte[]> classMap, String[] roots) throws Exception {
        MethodReachabilityDetector detector = new MethodReachabilityDetector(mainClassName, classMap, roots);
        return detector.getClassInfoMap();
    }

    private MethodReachabilityDetector(String mainClassName, Map<String, byte[]> classMap, String[] roots) throws Exception {
        this.classInfoMap = JarDependencyCollector.getClassInfoMap(classMap);
        ClassInfo mainClassInfo = this.classInfoMap.get(mainClassName);
        if (null == mainClassInfo) {
            throw new Exception("Main class info not found for class " + mainClassName);
        }
        this.methodQueue = new LinkedList<MethodInfo>();
        for (String m : roots) {
            MethodInfo mi = mainClassInfo.getMethodMap().get(m);
            if (null == mi) {
                throw new Exception(String.format("Method info %s not found!", m));
            }
            mi.isReachable = true;
            this.methodQueue.add(mi);
        }
        for (ClassInfo classInfo : this.classInfoMap.values()) {
            this.methodQueue.addAll(classInfo.getAlwaysReachables());
        }
        this.traverse();
    }

    private void traverse() throws Exception {
        while (!this.methodQueue.isEmpty()) {
            MethodInfo methodInfo = this.methodQueue.remove();
            if (!methodInfo.isReachable) {
                throw new Exception("This method should have been marked as reachable!");
            }
            block5: for (MethodInvocation invocation : methodInfo.methodInvocations) {
                ClassInfo ownerClass = this.classInfoMap.get(invocation.className);
                if (null == ownerClass) continue;
                MethodInfo calledMethod = ownerClass.getMethodMap().get(invocation.methodIdentifier);
                if (ownerClass.isSystemClass() && null == calledMethod) {
                    throw new UnsupportedOperationException("Unsupported JCL method detected: " + invocation.className + "#" + invocation.methodIdentifier);
                }
                switch (invocation.invocationOpcode) {
                    case 183: {
                        this.enqueue(calledMethod);
                        continue block5;
                    }
                    case 182: 
                    case 184: 
                    case 185: 
                    case 186: {
                        this.enqueueSelfAndChildren(ownerClass, invocation.methodIdentifier);
                        continue block5;
                    }
                }
                throw new Exception("This is not an invoke method opcode");
            }
        }
    }

    private void enqueueSelfAndChildren(ClassInfo classInfo, String methodId) {
        MethodInfo methodInfo = classInfo.getDeclaration(methodId);
        if (null == methodInfo) {
            throw new IllegalArgumentException("No declaration found for " + methodId + ", corrupt jar suspected");
        }
        this.enqueue(methodInfo);
        if (!methodInfo.isStatic) {
            for (ClassInfo childClassInfo : classInfo.getChildren()) {
                MethodInfo childMethodInfo = childClassInfo.getMethodMap().get(methodId);
                if (null != childMethodInfo) {
                    this.enqueue(childMethodInfo);
                    continue;
                }
                if (!classInfo.isInterface() || childClassInfo.isInterface() || childClassInfo.isAbstract()) continue;
                MethodInfo concreteImplInfo = childClassInfo.getConcreteImplementation(methodId);
                if (null == concreteImplInfo) {
                    throw new IllegalArgumentException("No implementation found for " + methodId + ", corrupt jar suspected");
                }
                this.enqueue(concreteImplInfo);
            }
        }
    }

    private void enqueue(MethodInfo methodInfo) {
        if (!methodInfo.isReachable) {
            methodInfo.isReachable = true;
            this.methodQueue.add(methodInfo);
        }
    }

    private Map<String, ClassInfo> getClassInfoMap() {
        return this.classInfoMap;
    }
}

