/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.tooling.abi;

import foundation.icon.ee.tooling.abi.ABICompilerException;
import foundation.icon.ee.tooling.abi.ABICompilerFieldVisitor;
import foundation.icon.ee.tooling.abi.ABICompilerMethodVisitor;
import foundation.icon.ee.types.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ABICompilerClassVisitor
extends ClassVisitor {
    private List<ABICompilerMethodVisitor> methodVisitors = new ArrayList<ABICompilerMethodVisitor>();
    private List<Method> callableInfo = new ArrayList<Method>();
    private boolean stripLineNumber;

    public ABICompilerClassVisitor(ClassWriter cw, boolean stripLineNumber) {
        super(458752, (ClassVisitor)cw);
        this.stripLineNumber = stripLineNumber;
    }

    public List<Method> getCallableInfo() {
        return this.callableInfo;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return new ABICompilerFieldVisitor(access, name, descriptor, super.visitField(access, name, descriptor, signature, value));
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (name.equals("main") && (access & 1) != 0) {
            throw new ABICompilerException("main method cannot be defined", name);
        }
        ABICompilerMethodVisitor mv = new ABICompilerMethodVisitor(access, name, descriptor, super.visitMethod(access, name, descriptor, signature, exceptions), this.stripLineNumber);
        this.methodVisitors.add(mv);
        return mv;
    }

    public void visitEnd() {
        this.postProcess();
        super.visitEnd();
    }

    private void postProcess() {
        boolean foundOnInstall = false;
        HashSet<String> callableNames = new HashSet<String>();
        HashSet<String> eventsNames = new HashSet<String>();
        for (ABICompilerMethodVisitor mv : this.methodVisitors) {
            if (mv.isExternal()) {
                if (callableNames.contains(mv.getMethodName())) {
                    throw new ABICompilerException("Multiple @External methods with the same name", mv.getMethodName());
                }
                callableNames.add(mv.getMethodName());
                this.callableInfo.add(mv.getCallableMethodInfo());
                continue;
            }
            if (mv.isOnInstall()) {
                if (foundOnInstall) {
                    throw new ABICompilerException("Multiple public <init> methods", mv.getMethodName());
                }
                foundOnInstall = true;
                this.callableInfo.add(mv.getCallableMethodInfo());
                continue;
            }
            if (mv.isEventLog()) {
                if (eventsNames.contains(mv.getMethodName())) {
                    throw new ABICompilerException("Multiple @EventLog methods with the same name", mv.getMethodName());
                }
                eventsNames.add(mv.getMethodName());
                this.callableInfo.add(mv.getCallableMethodInfo());
                continue;
            }
            if (!mv.isFallback()) continue;
            this.callableInfo.add(mv.getCallableMethodInfo());
        }
    }
}

