/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.tooling.abi;

import foundation.icon.ee.tooling.abi.ABICompilerClassVisitor;
import foundation.icon.ee.tooling.abi.ABICompilerException;
import foundation.icon.ee.types.Method;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import org.aion.avm.utilities.JarBuilder;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ABICompiler {
    private String mainClassName;
    private byte[] mainClassBytes;
    private byte[] outputJarFile;
    private List<Method> callables;
    private Map<String, byte[]> classMap = new HashMap<String, byte[]>();
    private boolean stripLineNumber;

    public static ABICompiler compileJar(InputStream byteReader, boolean stripLineNumber) {
        return ABICompiler.initCompilerAndCompile(byteReader, stripLineNumber);
    }

    public static ABICompiler compileJarBytes(byte[] rawBytes, boolean stripLineNumber) {
        return ABICompiler.initCompilerAndCompile(new ByteArrayInputStream(rawBytes), stripLineNumber);
    }

    private static ABICompiler initCompilerAndCompile(InputStream byteReader, boolean stripLineNumber) {
        ABICompiler compiler = new ABICompiler();
        compiler.stripLineNumber = stripLineNumber;
        compiler.compile(byteReader);
        return compiler;
    }

    private ABICompiler() {
    }

    private void compile(InputStream byteReader) {
        try {
            this.safeLoadFromBytes(byteReader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClassReader reader = new ClassReader(this.mainClassBytes);
        ClassWriter classWriter = new ClassWriter(1);
        ABICompilerClassVisitor classVisitor = new ABICompilerClassVisitor(classWriter, this.stripLineNumber);
        reader.accept((ClassVisitor)classVisitor, 0);
        this.callables = classVisitor.getCallableInfo();
        this.mainClassBytes = classWriter.toByteArray();
        this.outputJarFile = JarBuilder.buildJarForExplicitClassNamesAndBytecode((String)this.mainClassName, (byte[])this.mainClassBytes, this.classMap, (Class[])new Class[0]);
    }

    private void safeLoadFromBytes(InputStream byteReader) throws Exception {
        JarInputStream jarReader = new JarInputStream(byteReader, true);
        this.classMap = Utilities.extractClasses((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
        this.mainClassName = Utilities.extractMainClassName((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
        this.mainClassBytes = this.classMap.get(this.mainClassName);
        if (this.mainClassBytes == null) {
            throw new ABICompilerException("Cannot find main class: " + this.mainClassName);
        }
        this.classMap.remove(this.mainClassName);
    }

    public List<Method> getCallables() {
        return this.callables;
    }

    public byte[] getJarFileBytes() {
        return this.outputJarFile;
    }
}

