/*
 * Decompiled with CFR 0.152.
 */
package scorex.util;

import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection<E>
implements Collection<E> {
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        Iterator<E> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                e.remove();
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                e.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    public String toString() {
        Iterator<E> i = this.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = i.next()) == this ? "(this Collection)" : e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }
}

