/*
 * Decompiled with CFR 0.152.
 */
package scorex.io;

import scorex.io.IOException;

public abstract class Writer {
    private static final int WRITE_BUFFER_SIZE = 1024;
    private char[] writeBuffer;

    protected Writer() {
    }

    public void write(int c) throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = new char[1024];
        }
        this.writeBuffer[0] = (char)c;
        this.write(this.writeBuffer, 0, 1);
    }

    public void write(char[] ca) throws IOException {
        this.write(ca, 0, ca.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        char[] ca;
        if (len <= 1024) {
            if (this.writeBuffer == null) {
                this.writeBuffer = new char[1024];
            }
            ca = this.writeBuffer;
        } else {
            ca = new char[len];
        }
        str.getChars(off, off + len, ca, 0);
        this.write(ca, 0, len);
    }

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;
}

