/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.score.json;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import foundation.icon.annotation_processor.AbstractProcessor;
import foundation.icon.annotation_processor.AnnotatedTypeElement;
import foundation.icon.annotation_processor.ProcessorUtil;
import foundation.icon.score.json.JsonObject;
import foundation.icon.score.json.JsonProperty;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import score.Address;
import score.ArrayDB;
import score.DictDB;
import score.VarDB;
import scorex.util.ArrayList;

public class JsonObjectProcessor
extends AbstractProcessor {
    static final String PARAM_OBJECT = "obj";
    static final String PARAM_JSON_VALUE = "jsonValue";
    static final String LOCAL_JSON_OBJECT = "jsonObject";
    static final String DEFAULT_FORMAT_TO = "$L";
    private Map<TypeMirror, Format> formats;
    private List<TypeMirror> listTypes;
    private List<TypeMirror> mapTypes;
    private Map<TypeMirror, String> dbConstructors;
    private TypeMirror bytesType;
    private TypeMirror convertType;

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.convertType = super.getTypeMirror(JsonValue.class);
        this.bytesType = super.getTypeMirror(byte[].class);
        this.listTypes = new java.util.ArrayList<TypeMirror>();
        this.listTypes.add(super.getTypeMirror(List.class));
        this.listTypes.add(super.getTypeMirror(ArrayList.class));
        this.mapTypes = new java.util.ArrayList<TypeMirror>();
        this.mapTypes.add(super.getTypeMirror(Map.class));
        this.mapTypes.add(super.getTypeMirror(scorex.util.HashMap.class));
        this.dbConstructors = new HashMap<TypeMirror, String>();
        this.dbConstructors.put(super.getTypeMirror(VarDB.class), "newVarDB");
        this.dbConstructors.put(super.getTypeMirror(ArrayDB.class), "newArrayDB");
        this.dbConstructors.put(super.getTypeMirror(DictDB.class), "newDictDB");
        this.formats = new HashMap<TypeMirror, Format>();
        this.formats.put(super.getTypeMirror(Boolean.class), new Format("$L.asBoolean()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(Character.class), new Format("(char)$L.asInt()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(Byte.class), new Format("(byte)$L.asInt()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(Short.class), new Format("(short)$L.asInt()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(Integer.class), new Format("$L.asInt()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(Long.class), new Format("$L.asLong()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(Float.class), new Format("$L.asFloat()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(Double.class), new Format("$L.asDouble()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(String.class), new Format("$L.asString()", DEFAULT_FORMAT_TO));
        this.formats.put(super.getTypeMirror(BigInteger.class), new Format("new BigInteger($L.asString())", "$L.toString()"));
        this.formats.put(super.getTypeMirror(Address.class), new Format("Address.fromString($L.asString())", "$L.toString()"));
        this.formats.put(super.getTypeMirror(byte[].class), new Format("scorex.util.Base64.getDecoder().decode($L.asString().getBytes())", "new String(scorex.util.Base64.getEncoder().encode($L))"));
    }

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> s = new HashSet<String>();
        s.add(JsonObject.class.getCanonicalName());
        return s;
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ret = false;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotationElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotationElements) {
                if (element.getKind().isClass()) {
                    this.messager.noteMessage("%s", new Object[]{element.toString()});
                    this.generateExtendsClass(this.processingEnv.getFiler(), (TypeElement)element);
                    ret = true;
                    continue;
                }
                throw new RuntimeException("not support");
            }
        }
        return ret;
    }

    private void generateExtendsClass(Filer filer, TypeElement element) {
        ClassName parentClassName = ClassName.get((TypeElement)element);
        TypeSpec typeSpec = this.typeSpec(element);
        JavaFile javaFile = JavaFile.builder((String)parentClassName.packageName(), (TypeSpec)typeSpec).build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ClassName getJsonObjectClassName(AnnotatedTypeElement<JsonObject> annotated) {
        TypeElement element = annotated.getElement();
        JsonObject ann = (JsonObject)annotated.getAnnotation();
        return ClassName.get((String)ClassName.get((TypeElement)element).packageName(), (String)(element.getSimpleName() + ann.suffix()), (String[])new String[0]);
    }

    private CodeBlock getParseStatement(TypeMirror variableType, String jsonValue, JsonProperty annProperty) {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        if (annProperty != null && !annProperty.parser().isEmpty()) {
            codeBlock.add("$L($L.asObject())", new Object[]{annProperty.parser(), jsonValue});
        } else {
            Map.Entry<TypeMirror, Format> entry = this.getFormat(variableType);
            if (entry != null) {
                codeBlock.add(entry.getValue().getParse(), new Object[]{jsonValue});
            } else {
                AnnotatedTypeElement annotated = super.getAnnotatedTypeElement(variableType, JsonObject.class);
                if (annotated != null) {
                    ClassName fieldClassName = JsonObjectProcessor.getJsonObjectClassName((AnnotatedTypeElement<JsonObject>)annotated);
                    codeBlock.add("$T.$L($L.asObject())", new Object[]{fieldClassName, ((JsonObject)annotated.getAnnotation()).parse(), jsonValue});
                } else {
                    String method = super.findMethod(variableType, ".*", variableType, new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}, new TypeMirror[]{this.convertType});
                    if (method != null) {
                        codeBlock.add("$T.$L($L.asObject())", new Object[]{variableType, method, jsonValue});
                    } else {
                        throw new RuntimeException(String.format("%s class is not JsonObject convertible, refer %s", variableType, jsonValue));
                    }
                }
            }
        }
        return codeBlock.build();
    }

    private CodeBlock getToJsonStatement(TypeMirror variableType, String variableName, JsonProperty annProperty) {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        if (annProperty != null && !annProperty.toJson().isEmpty()) {
            codeBlock.add("$L($L)", new Object[]{annProperty.toJson(), variableName});
        } else {
            Map.Entry<TypeMirror, Format> entry = this.getFormat(variableType);
            if (entry != null) {
                String toJson = String.format(entry.getValue().getTo(), variableName);
                if (!variableType.getKind().isPrimitive()) {
                    codeBlock.add("$L == null ? $T.NULL : ", new Object[]{variableName, Json.class});
                }
                codeBlock.add("$T.value(", new Object[]{Json.class}).add(entry.getValue().getTo(), new Object[]{variableName}).add(")", new Object[0]);
            } else {
                AnnotatedTypeElement annotated = super.getAnnotatedTypeElement(variableType, JsonObject.class);
                if (annotated != null) {
                    ClassName fieldClassName = JsonObjectProcessor.getJsonObjectClassName((AnnotatedTypeElement<JsonObject>)annotated);
                    codeBlock.add("$L == null ? $T.NULL : ", new Object[]{variableName, Json.class}).add("$T.$L($L)", new Object[]{fieldClassName, ((JsonObject)annotated.getAnnotation()).toJson(), variableName});
                } else {
                    String method = super.findMethod(variableType, ".*", this.convertType, new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}, new TypeMirror[]{variableType});
                    if (method != null) {
                        codeBlock.add("$L == null ? $T.NULL : ", new Object[]{variableName, Json.class}).add("$T.$L($L)", new Object[]{variableType, method, variableName});
                    } else {
                        throw new RuntimeException(String.format("%s class is not JsonObject convertible, refer %s", variableType, variableName));
                    }
                }
            }
        }
        return codeBlock.build();
    }

    private Map.Entry<TypeMirror, Format> getFormat(TypeMirror variableType) {
        for (Map.Entry<TypeMirror, Format> entry : this.formats.entrySet()) {
            if (!this.typeUtil.isAssignable(variableType, entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    private TypeSpec typeSpec(TypeElement element) {
        ClassName parentClassName = ClassName.get((TypeElement)element);
        JsonObject annClass = element.getAnnotation(JsonObject.class);
        ClassName className = ClassName.get((String)parentClassName.packageName(), (String)(parentClassName.simpleName() + annClass.suffix()), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)ClassName.get((String)parentClassName.packageName(), (String)className.simpleName(), (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(element.asType());
        builder.addMethod(MethodSpec.constructorBuilder().addStatement("super()", new Object[0]).build());
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addParameter(TypeName.get((TypeMirror)element.asType()), PARAM_OBJECT, new Modifier[0]).addStatement("super()", new Object[0]);
        builder.addMethod(MethodSpec.methodBuilder((String)annClass.parse()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, "jsonString", new Modifier[0]).returns((TypeName)className).addStatement("return $T.$L($T.parse(jsonString))", new Object[]{className, annClass.parse(), Json.class}).build());
        MethodSpec.Builder parseMethod = MethodSpec.methodBuilder((String)annClass.parse()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(TypeName.get((TypeMirror)this.convertType), PARAM_JSON_VALUE, new Modifier[0]).returns((TypeName)className).beginControlFlow("if ($L == null || $L.isNull())", new Object[]{PARAM_JSON_VALUE, PARAM_JSON_VALUE}).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T $L = $L.asObject()", new Object[]{com.eclipsesource.json.JsonObject.class, LOCAL_JSON_OBJECT, PARAM_JSON_VALUE}).addStatement("$T obj = new $T()", new Object[]{className, className});
        builder.addMethod(MethodSpec.methodBuilder((String)annClass.toJson()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(TypeName.get((TypeMirror)element.asType()), PARAM_OBJECT, new Modifier[0]).returns(TypeName.get((TypeMirror)this.convertType)).addStatement("return $L == null ? $T.NULL : new $T($L).$L()", new Object[]{PARAM_OBJECT, Json.class, className, PARAM_OBJECT, annClass.toJson()}).build());
        MethodSpec.Builder toJsonMethod = MethodSpec.methodBuilder((String)annClass.toJson()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(com.eclipsesource.json.JsonObject.class).addStatement("$T $L = $T.object()", new Object[]{com.eclipsesource.json.JsonObject.class, LOCAL_JSON_OBJECT, Json.class});
        this.processMethod(element, constructor, parseMethod, toJsonMethod);
        builder.addMethod(constructor.build());
        builder.addMethod(parseMethod.addStatement("return $L", new Object[]{PARAM_OBJECT}).build());
        builder.addMethod(toJsonMethod.addStatement("return $L", new Object[]{LOCAL_JSON_OBJECT}).build());
        return builder.build();
    }

    private void processMethod(TypeElement element, MethodSpec.Builder constructor, MethodSpec.Builder parseMethod, MethodSpec.Builder toJsonMethod) {
        TypeMirror superClass = element.getSuperclass();
        TypeElement superElement = super.getTypeElement(superClass);
        if (superElement != null) {
            this.processMethod(superElement, constructor, parseMethod, toJsonMethod);
        }
        for (Element element2 : element.getEnclosedElements()) {
            CodeBlock setterValue;
            boolean isArray;
            String field;
            if (!element2.getKind().equals((Object)ElementKind.FIELD) || ProcessorUtil.hasModifier((Element)element2, (Modifier[])new Modifier[]{Modifier.STATIC})) continue;
            VariableElement variableElement = (VariableElement)element2;
            TypeMirror fieldType = variableElement.asType();
            JsonProperty annField = variableElement.getAnnotation(JsonProperty.class);
            if (annField != null && annField.ignore() || super.containsDeclaredType(this.dbConstructors.keySet(), fieldType)) continue;
            String property = field = variableElement.getSimpleName().toString();
            String capitalized = field.substring(0, 1).toUpperCase() + field.substring(1);
            Object getter = (fieldType.getKind() == TypeKind.BOOLEAN ? "is" : "get") + capitalized;
            Object setter = "set" + capitalized;
            boolean direct = false;
            if (annField != null) {
                direct = annField.direct();
                if (!annField.value().isEmpty()) {
                    property = annField.value();
                }
                if (!annField.getter().isEmpty()) {
                    getter = annField.getter();
                }
                if (!annField.setter().isEmpty()) {
                    setter = annField.setter();
                }
            }
            if (direct) {
                constructor.addStatement("this.$L = $L.$L", new Object[]{field, PARAM_OBJECT, field});
                toJsonMethod.addStatement("$T $L = this.$L", new Object[]{fieldType, field, field});
            } else {
                constructor.addStatement("this.$L($L.$L())", new Object[]{setter, PARAM_OBJECT, getter});
                toJsonMethod.addStatement("$T $L = this.$L()", new Object[]{fieldType, field, getter});
            }
            String jsonValue = field + "JsonValue";
            parseMethod.addStatement("$T $L = $L.get(\"$L\")", new Object[]{JsonValue.class, jsonValue, LOCAL_JSON_OBJECT, property});
            parseMethod.beginControlFlow("if ($L != null && !$L.isNull())", new Object[]{jsonValue, jsonValue});
            boolean bl = isArray = fieldType.getKind() == TypeKind.ARRAY;
            if (super.containsDeclaredType(this.mapTypes, fieldType)) {
                List<? extends TypeMirror> types = ((DeclaredType)fieldType).getTypeArguments();
                TypeMirror keyType = types.get(0);
                TypeMirror valueType = types.get(1);
                String jsonObjectName = field + "JsonObject";
                toJsonMethod.addStatement("$T $L = $T.object()", new Object[]{com.eclipsesource.json.JsonObject.class, jsonObjectName, Json.class}).beginControlFlow("for($T<$T,$T> entry : $L.entrySet())", new Object[]{Map.Entry.class, keyType, valueType, field}).addStatement("$L.add(entry.getKey(), $L)", new Object[]{jsonObjectName, this.getToJsonStatement(valueType, "entry.getValue()", annField)}).endControlFlow();
                parseMethod.addStatement("$T $L = $L.asObject()", new Object[]{com.eclipsesource.json.JsonObject.class, jsonObjectName, jsonValue}).addStatement("$T $L = new $T<>()", new Object[]{fieldType, field, scorex.util.HashMap.class}).beginControlFlow("for(String name : $L.names())", new Object[]{jsonObjectName}).addStatement("$L.put(name, $L)", new Object[]{field, this.getParseStatement(valueType, jsonObjectName + ".get(name)", annField)}).endControlFlow();
                setterValue = CodeBlock.builder().add(DEFAULT_FORMAT_TO, new Object[]{field}).build();
                jsonValue = jsonObjectName;
            } else if (!this.typeUtil.isSameType(fieldType, this.bytesType) && (isArray || super.containsDeclaredType(this.listTypes, fieldType))) {
                TypeMirror componentType = ProcessorUtil.getComponentType((TypeMirror)fieldType);
                int componentDepth = ProcessorUtil.getComponentTypeDepth((TypeMirror)fieldType);
                if (componentType.getKind() == TypeKind.BYTE) {
                    --componentDepth;
                    componentType = this.typeUtil.getArrayType(componentType);
                }
                String jsonArrayName = field + "JsonArray";
                if (isArray) {
                    int i;
                    TypeMirror constructComponentType = this.typeUtil.isSameType(componentType, this.bytesType) ? ProcessorUtil.getComponentType((TypeMirror)fieldType) : componentType;
                    for (i = 0; i < componentDepth; ++i) {
                        String braket = "[]".repeat(componentDepth - i - 1);
                        if (constructComponentType.getKind() == TypeKind.BYTE) {
                            braket = "[]".repeat(componentDepth - i);
                        }
                        String suffix = i == 0 ? "" : Integer.toString(i);
                        String jsonArray = field + "JsonArray" + suffix;
                        String fieldName = field + suffix;
                        String index = "i" + suffix;
                        parseMethod.addStatement("$T $L = $L.asArray()", new Object[]{JsonArray.class, jsonArray, field + "JsonValue" + suffix}).addStatement("$T[]$L $L = new $T[$L.size()]$L", new Object[]{constructComponentType, braket, fieldName, constructComponentType, jsonArray, braket}).beginControlFlow("for(int $L=0; $L<$L.size(); $L++)", new Object[]{index, index, jsonArray, index}).addStatement("$T $L = $L.get($L)", new Object[]{JsonValue.class, field + "JsonValue" + (i + 1), jsonArray, index}).beginControlFlow("if (!$L.isNull())", new Object[]{field + "JsonValue" + (i + 1)});
                        toJsonMethod.beginControlFlow("if ($L != null)", new Object[]{fieldName}).addStatement("$T $L = $T.array()", new Object[]{JsonArray.class, jsonArray, Json.class}).beginControlFlow("for($T$L $L : $L)", new Object[]{constructComponentType, braket, i + 1 == componentDepth ? "v" : field + (i + 1), fieldName});
                    }
                    for (i = componentDepth; i > 0; --i) {
                        CodeBlock addNullCode;
                        CodeBlock addCode;
                        String suffix = i == 1 ? "" : Integer.toString(i - 1);
                        String jsonArray = field + "JsonArray" + suffix;
                        String fieldName = field + suffix;
                        String index = "i" + suffix;
                        if (i == componentDepth) {
                            setterValue = this.getParseStatement(componentType, field + "JsonValue" + i, annField);
                            toJsonMethod.addStatement("$L.add($L)", new Object[]{jsonArray, this.getToJsonStatement(componentType, "v", annField)});
                        } else {
                            setterValue = CodeBlock.builder().add(DEFAULT_FORMAT_TO, new Object[]{field + i}).build();
                        }
                        if (i == 1) {
                            addCode = CodeBlock.builder().addStatement("$L.add(\"$L\", $L)", new Object[]{LOCAL_JSON_OBJECT, property, jsonArray}).build();
                            addNullCode = CodeBlock.builder().addStatement("$L.add(\"$L\", $T.NULL)", new Object[]{LOCAL_JSON_OBJECT, property, Json.class}).build();
                        } else {
                            String parentSuffix = i <= 2 ? "" : Integer.toString(i - 2);
                            String parentArray = field + "JsonArray" + parentSuffix;
                            addCode = CodeBlock.builder().addStatement("$L.add($L)", new Object[]{parentArray, jsonArray}).build();
                            addNullCode = CodeBlock.builder().addStatement("$L.add($T.NULL)", new Object[]{parentArray, Json.class}).build();
                        }
                        toJsonMethod.endControlFlow();
                        toJsonMethod.addCode(addCode);
                        toJsonMethod.nextControlFlow("else", new Object[0]);
                        toJsonMethod.addCode(addNullCode);
                        toJsonMethod.endControlFlow();
                        parseMethod.addStatement("$L[$L] = $L", new Object[]{fieldName, index, setterValue}).endControlFlow().endControlFlow();
                    }
                } else {
                    setterValue = this.getParseStatement(componentType, jsonArrayName + ".get(i)", annField);
                    parseMethod.addStatement("$T $L = $L.asArray()", new Object[]{JsonArray.class, jsonArrayName, jsonValue}).addStatement("$T $L = new $T<>()", new Object[]{fieldType, field, ArrayList.class}).beginControlFlow("for(int i=0; i<$L.size(); i++)", new Object[]{jsonArrayName}).addStatement("$L.add($L)", new Object[]{field, setterValue}).endControlFlow();
                    toJsonMethod.addStatement("$T $L = $T.array()", new Object[]{JsonArray.class, jsonArrayName, Json.class}).beginControlFlow("for($T v : $L)", new Object[]{componentType, field}).addStatement("$L.add($L)", new Object[]{jsonArrayName, this.getToJsonStatement(componentType, "v", annField)}).endControlFlow().addStatement("$L.add(\"$L\", $L)", new Object[]{LOCAL_JSON_OBJECT, property, jsonArrayName});
                }
                setterValue = CodeBlock.builder().add(DEFAULT_FORMAT_TO, new Object[]{field}).build();
            } else {
                setterValue = this.getParseStatement(fieldType, jsonValue, annField);
                toJsonMethod.addStatement("$T $L = $L", new Object[]{JsonValue.class, jsonValue, this.getToJsonStatement(fieldType, field, annField)}).addStatement("$L.add(\"$L\", $L)", new Object[]{LOCAL_JSON_OBJECT, property, jsonValue});
            }
            if (direct) {
                parseMethod.addStatement("obj.$L = $L", new Object[]{field, setterValue});
            } else {
                parseMethod.addStatement("obj.$L($L)", new Object[]{setter, setterValue});
            }
            parseMethod.endControlFlow();
        }
    }

    static class Format {
        private final String parse;
        private final String to;

        public Format(String parse, String to) {
            this.parse = parse;
            this.to = to;
        }

        public String getParse() {
            return this.parse;
        }

        public String getTo() {
            return this.to;
        }
    }
}

