/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.test.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFile {
    public static byte[] zipContent(String path) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        ZipFile.recursiveZip(new File(path), null, zos);
        zos.close();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private static void recursiveZip(File source, String zipPath, ZipOutputStream zos) throws IOException {
        if (source.isHidden()) {
            return;
        }
        if (source.isDirectory()) {
            Object dir = source.getName();
            if (!((String)dir).endsWith(File.separator)) {
                dir = (String)dir + File.separator;
            }
            zos.putNextEntry(new ZipEntry((String)dir));
            zos.closeEntry();
            File[] files = source.listFiles();
            if (files == null) {
                return;
            }
            Object path = zipPath == null ? dir : zipPath + (String)dir;
            for (File file : files) {
                ZipFile.recursiveZip(file, (String)path, zos);
            }
        } else {
            ZipEntry ze = new ZipEntry(zipPath + source.getName());
            zos.putNextEntry(ze);
            zos.write(Files.readAllBytes(source.toPath()));
            zos.closeEntry();
        }
    }
}

