/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.test.score;

import foundation.icon.icx.Call;
import foundation.icon.icx.Transaction;
import foundation.icon.icx.TransactionBuilder;
import foundation.icon.icx.Wallet;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.data.TransactionResult;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.test.Env;
import foundation.icon.test.ResultTimeoutException;
import foundation.icon.test.TransactionHandler;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;

public class Score {
    private final TransactionHandler txHandler;
    private final Address address;

    public Score(TransactionHandler txHandler, Address scoreAddress) {
        this.txHandler = txHandler;
        this.address = scoreAddress;
    }

    public Score(Score other) {
        this(other.txHandler, other.address);
    }

    public static String getFilePath(String pkgName) {
        String key = "score.path." + pkgName;
        String path = System.getProperty(key);
        if (path == null) {
            String scoreRoot = Env.getScoreRoot();
            if (scoreRoot != null) {
                return scoreRoot + pkgName;
            }
            throw new IllegalArgumentException("No such property: " + key);
        }
        return path;
    }

    protected static TransactionResult.EventLog findEventLog(TransactionResult result, Address scoreAddress, String funcSig) {
        List eventLogs = result.getEventLogs();
        for (TransactionResult.EventLog event : eventLogs) {
            String signature;
            if (!event.getScoreAddress().equals(scoreAddress.toString()) || !funcSig.equals(signature = ((RpcItem)event.getIndexed().get(0)).asString())) continue;
            return event;
        }
        return null;
    }

    public RpcItem call(String method, RpcObject params) throws IOException {
        if (params == null) {
            params = new RpcObject.Builder().build();
        }
        Call call = new Call.Builder().to(this.getAddress()).method(method).params((RpcItem)params).build();
        return this.txHandler.call((Call<RpcItem>)call);
    }

    public Bytes invoke(Wallet wallet, String method, RpcObject params) throws IOException {
        return this.invoke(wallet, method, params, BigInteger.ZERO, null);
    }

    public Bytes invoke(Wallet wallet, String method, RpcObject params, BigInteger value, BigInteger steps) throws IOException {
        return this.invoke(wallet, method, params, value, steps, null, null);
    }

    public Bytes invoke(Wallet wallet, Transaction tx) throws IOException {
        return this.txHandler.invoke(wallet, tx, null);
    }

    public Bytes invoke(Wallet wallet, String method, RpcObject params, BigInteger value, BigInteger steps, BigInteger timestamp, BigInteger nonce) throws IOException {
        Transaction tx = this.getTransaction(wallet, method, params, value, timestamp, nonce);
        return this.txHandler.invoke(wallet, tx, steps);
    }

    private Transaction getTransaction(Wallet wallet, String method, RpcObject params, BigInteger value, BigInteger timestamp, BigInteger nonce) {
        TransactionBuilder.Builder builder = TransactionBuilder.newBuilder().nid(this.getNetworkId()).from(wallet.getAddress()).to(this.getAddress());
        if (value != null && value.bitLength() != 0) {
            builder.value(value);
        }
        if (timestamp != null && timestamp.bitLength() != 0) {
            builder.timestamp(timestamp);
        }
        if (nonce != null) {
            builder.nonce(nonce);
        }
        Transaction tx = params != null ? builder.call(method).params(params).build() : builder.call(method).build();
        return tx;
    }

    public TransactionResult invokeAndWaitResult(Wallet wallet, String method, RpcObject params) throws ResultTimeoutException, IOException {
        return this.invokeAndWaitResult(wallet, method, params, null, null);
    }

    public TransactionResult invokeAndWaitResult(Wallet wallet, String method, RpcObject params, BigInteger steps) throws ResultTimeoutException, IOException {
        return this.invokeAndWaitResult(wallet, method, params, null, steps);
    }

    public TransactionResult invokeAndWaitResult(Wallet wallet, String method, RpcObject params, BigInteger value, BigInteger steps) throws ResultTimeoutException, IOException {
        Bytes txHash = this.invoke(wallet, method, params, value, steps);
        return this.getResult(txHash);
    }

    public TransactionResult getResult(Bytes txHash) throws ResultTimeoutException, IOException {
        return this.getResult(txHash, 7000L);
    }

    public TransactionResult getResult(Bytes txHash, long waiting) throws ResultTimeoutException, IOException {
        return this.txHandler.getResult(txHash, waiting);
    }

    protected TransactionHandler getTxHandler() {
        return this.txHandler;
    }

    public Address getAddress() {
        return this.address;
    }

    public BigInteger getNetworkId() {
        return this.txHandler.getNetworkId();
    }

    public String toString() {
        return "SCORE(" + this.getAddress().toString() + ")";
    }
}

