/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.test.score;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import foundation.icon.test.Constants;
import foundation.icon.test.TransactionHandler;
import foundation.icon.test.score.Score;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ChainScore
extends Score {
    private static final int CONFIG_AUDIT = 2;

    public ChainScore(TransactionHandler txHandler) {
        super(txHandler, Constants.SYSTEM_ADDRESS);
    }

    public int getRevision() throws IOException {
        return this.call("getRevision", null).asInteger().intValue();
    }

    public BigInteger getStepPrice() throws IOException {
        return this.call("getStepPrice", null).asInteger();
    }

    public int getServiceConfig() throws IOException {
        return this.call("getServiceConfig", null).asInteger().intValue();
    }

    public Map<String, BigInteger> getStepCosts() throws Exception {
        RpcItem rpcItem = this.call("getStepCosts", null);
        HashMap<String, BigInteger> map = new HashMap<String, BigInteger>();
        Set stepCostTypes = rpcItem.asObject().keySet();
        for (String type : stepCostTypes) {
            map.put(type, rpcItem.asObject().getItem(type).asInteger());
        }
        return map;
    }

    public static boolean isAuditEnabled(int config) {
        return (config & 2) != 0;
    }

    public boolean isAuditEnabled() throws IOException {
        return ChainScore.isAuditEnabled(this.getServiceConfig());
    }

    public RpcObject getScoreStatus(Address address) throws IOException {
        RpcObject params = new RpcObject.Builder().put("address", (RpcItem)new RpcValue(address)).build();
        return this.call("getScoreStatus", params).asObject();
    }
}

