/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.test;

import foundation.icon.icx.Call;
import foundation.icon.icx.IconService;
import foundation.icon.icx.SignedTransaction;
import foundation.icon.icx.Transaction;
import foundation.icon.icx.TransactionBuilder;
import foundation.icon.icx.Wallet;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.data.ConfirmedTransaction;
import foundation.icon.icx.data.ScoreApi;
import foundation.icon.icx.data.TransactionResult;
import foundation.icon.icx.transport.jsonrpc.RpcError;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.test.Constants;
import foundation.icon.test.Env;
import foundation.icon.test.ResultTimeoutException;
import foundation.icon.test.TransactionFailureException;
import foundation.icon.test.score.ChainScore;
import foundation.icon.test.score.Score;
import foundation.icon.test.util.ZipFile;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public class TransactionHandler {
    private final IconService iconService;
    private final Env.Chain chain;

    public TransactionHandler(IconService iconService, Env.Chain chain) {
        this.iconService = iconService;
        this.chain = chain;
    }

    public Score deploy(Wallet owner, String scorePath, RpcObject params) throws IOException, ResultTimeoutException, TransactionFailureException {
        return this.deploy(owner, scorePath, params, null);
    }

    public Score deploy(Wallet owner, String scorePath, RpcObject params, BigInteger steps) throws IOException, ResultTimeoutException, TransactionFailureException {
        return this.deploy(owner, scorePath, Constants.SYSTEM_ADDRESS, params, steps);
    }

    public Score deploy(Wallet owner, String scorePath, Address to, RpcObject params, BigInteger steps) throws IOException, ResultTimeoutException, TransactionFailureException {
        if (scorePath.endsWith(".jar")) {
            byte[] data = Files.readAllBytes(Path.of(scorePath, new String[0]));
            return this.getScore(this.doDeploy(owner, data, to, params, steps, "application/java"));
        }
        byte[] data = ZipFile.zipContent(scorePath);
        return this.getScore(this.doDeploy(owner, data, to, params, steps, "application/zip"));
    }

    public Bytes doDeploy(Wallet owner, byte[] content, Address to, RpcObject params, BigInteger steps, String contentType) throws IOException {
        Transaction transaction = TransactionBuilder.newBuilder().nid(this.getNetworkId()).from(owner.getAddress()).to(to).deploy(contentType, content).params(params).build();
        if (steps == null) {
            steps = this.estimateStep(transaction);
        }
        SignedTransaction signedTransaction = new SignedTransaction(transaction, owner, steps);
        return (Bytes)this.iconService.sendTransaction(signedTransaction).execute();
    }

    public Score getScore(Bytes txHash) throws IOException, ResultTimeoutException, TransactionFailureException {
        TransactionResult result = this.getResult(txHash, 7000L);
        if (!Constants.STATUS_SUCCESS.equals(result.getStatus())) {
            throw new TransactionFailureException(result.getFailure());
        }
        return new Score(this, new Address(result.getScoreAddress()));
    }

    public Bytes deployOnly(Wallet owner, String scorePath, RpcObject params) throws IOException {
        return this.deployOnly(owner, Constants.SYSTEM_ADDRESS, scorePath, params);
    }

    public Bytes deployOnly(Wallet owner, Address to, String scorePath, RpcObject params) throws IOException {
        byte[] data = ZipFile.zipContent(scorePath);
        return this.doDeploy(owner, data, to, params, null, "application/zip");
    }

    public Env.Chain getChain() {
        return this.chain;
    }

    public BigInteger getNetworkId() {
        return BigInteger.valueOf(this.chain.networkId);
    }

    public BigInteger getBalance(Address address) throws IOException {
        return (BigInteger)this.iconService.getBalance(address).execute();
    }

    public List<ScoreApi> getScoreApi(Address scoreAddress) throws IOException {
        return (List)this.iconService.getScoreApi(scoreAddress).execute();
    }

    public BigInteger estimateStep(Transaction transaction) throws IOException {
        try {
            return (BigInteger)this.iconService.estimateStep(transaction).execute();
        }
        catch (RpcError e) {
            Env.LOG.info("estimateStep failed(" + e.getCode() + ", " + e.getMessage() + "); use default steps.");
            return Constants.DEFAULT_STEPS.multiply(BigInteger.TEN);
        }
    }

    public RpcItem call(Call<RpcItem> call) throws IOException {
        return (RpcItem)this.iconService.call(call).execute();
    }

    public Bytes invoke(Wallet wallet, Transaction tx, BigInteger steps) throws IOException {
        if (steps == null) {
            steps = this.estimateStep(tx);
        }
        return (Bytes)this.iconService.sendTransaction(new SignedTransaction(tx, wallet, steps)).execute();
    }

    public TransactionResult getResult(Bytes txHash) throws IOException, ResultTimeoutException {
        return this.getResult(txHash, 7000L);
    }

    public TransactionResult getResult(Bytes txHash, long waiting) throws IOException, ResultTimeoutException {
        long limitTime = System.currentTimeMillis() + waiting;
        while (true) {
            try {
                return (TransactionResult)this.iconService.getTransactionResult(txHash).execute();
            }
            catch (RpcError e) {
                if (e.getCode() == -31002L || e.getCode() == -31003L || e.getCode() == -31004L) {
                    if (limitTime < System.currentTimeMillis()) {
                        throw new ResultTimeoutException(txHash);
                    }
                    try {
                        Env.LOG.debug("RpcError: code(" + e.getCode() + ") message(" + e.getMessage() + "); Retry in 1 sec.");
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                Env.LOG.warning("RpcError: code(" + e.getCode() + ") message(" + e.getMessage() + ")");
                throw e;
            }
            break;
        }
    }

    public Bytes transfer(Address to, BigInteger amount) throws IOException {
        return this.transfer(this.chain.godWallet, to, amount);
    }

    public Bytes transfer(Wallet owner, Address to, BigInteger amount) throws IOException {
        return this.transfer(owner, to, amount, null);
    }

    public Bytes transfer(Wallet owner, Address to, BigInteger amount, BigInteger steps) throws IOException {
        Transaction transaction = TransactionBuilder.newBuilder().nid(this.getNetworkId()).from(owner.getAddress()).to(to).value(amount).build();
        if (steps == null) {
            steps = this.estimateStep(transaction).add(BigInteger.valueOf(10000L));
        }
        SignedTransaction signedTransaction = new SignedTransaction(transaction, owner, steps);
        return (Bytes)this.iconService.sendTransaction(signedTransaction).execute();
    }

    public void refundAll(Wallet owner) throws IOException {
        BigInteger stepPrice = new ChainScore(this).getStepPrice();
        BigInteger remaining = this.getBalance(owner.getAddress());
        BigInteger fee = Constants.DEFAULT_STEPS.multiply(stepPrice);
        this.transfer(owner, this.chain.godWallet.getAddress(), remaining.subtract(fee), Constants.DEFAULT_STEPS);
    }

    public ConfirmedTransaction getTransaction(Bytes txHash) throws IOException {
        return (ConfirmedTransaction)this.iconService.getTransaction(txHash).execute();
    }
}

