/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.test;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.data.TransactionResult;
import foundation.icon.test.Constants;
import foundation.icon.test.Env;
import foundation.icon.test.ResultTimeoutException;
import foundation.icon.test.TransactionHandler;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public class TestBase {
    protected static final BigInteger ICX = BigInteger.TEN.pow(18);

    protected static void assertSuccess(TransactionResult result) {
        TestBase.assertStatus(Constants.STATUS_SUCCESS, result);
    }

    protected static void assertFailure(TransactionResult result) {
        TestBase.assertStatus(Constants.STATUS_FAILURE, result);
        Env.LOG.info("Expected " + result.getFailure());
    }

    protected static void assertStatus(BigInteger status, TransactionResult result) {
        try {
            Assertions.assertEquals((Object)status, (Object)result.getStatus());
        }
        catch (AssertionFailedError e) {
            Env.LOG.info("Assertion Failed: result=" + result);
            Assertions.fail((String)e.getMessage());
        }
    }

    protected static void transferAndCheckResult(TransactionHandler txHandler, Address to, BigInteger amount) throws IOException, ResultTimeoutException {
        Bytes txHash = txHandler.transfer(to, amount);
        TestBase.assertSuccess(txHandler.getResult(txHash));
    }

    protected static void transferAndCheckResult(TransactionHandler txHandler, Address[] addresses, BigInteger amount) throws IOException, ResultTimeoutException {
        ArrayList<Bytes> hashes = new ArrayList<Bytes>();
        for (Address to : addresses) {
            hashes.add(txHandler.transfer(to, amount));
        }
        for (Bytes hash : hashes) {
            TestBase.assertSuccess(txHandler.getResult(hash));
        }
    }

    protected static void ensureIcxBalance(TransactionHandler txHandler, Address address, BigInteger oldVal, BigInteger newVal) throws Exception {
        String msg;
        BigInteger icxBalance;
        long limitTime = System.currentTimeMillis() + 7000L;
        while (true) {
            icxBalance = txHandler.getBalance(address);
            msg = "ICX balance of " + address + ": " + icxBalance;
            if (!icxBalance.equals(oldVal)) break;
            if (limitTime < System.currentTimeMillis()) {
                throw new ResultTimeoutException();
            }
            try {
                Env.LOG.debug(msg + "; Retry in 1 sec.");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!icxBalance.equals(newVal)) {
            throw new IOException(String.format("ICX balance mismatch: expected <%s>, but was <%s>", newVal, icxBalance));
        }
        Env.LOG.info(msg);
    }
}

