/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.test;

import java.util.EmptyStackException;
import java.util.Stack;

public class Log {
    private static final String[] PREFIX_LEVELS = new String[]{null, "[S]", "[W]", null, null};
    private static final String PREFIX_STEP_IN = "--> ";
    private static final String PREFIX_STEP_OUT = "<-- ";
    private static final String DEPTH_STRING = "   ";
    private static final int LEVEL_START = 0;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_SEVERE = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_DEBUG = 4;
    private static final int LEVEL_END = 4;
    private int level = 3;
    private Stack<String> frames = new Stack();

    public static Log getGlobal() {
        return new Log();
    }

    public void setLevel(int newLevel) {
        if (newLevel >= 0 && newLevel <= 4) {
            this.level = newLevel;
        }
    }

    private boolean isLoggable(int level) {
        return this.level >= level && level > 0;
    }

    public void info(String msg) {
        this.log(3, msg);
    }

    public void warning(String msg) {
        this.log(2, msg);
    }

    public void severe(String msg) {
        this.log(1, msg);
    }

    public void infoEntering(String taskName, String msg) {
        if (taskName == null) {
            taskName = "";
        }
        if (msg == null) {
            msg = "";
        }
        StringBuilder buf = new StringBuilder(5 + taskName.length() + msg.length());
        buf.append(PREFIX_STEP_IN).append(taskName);
        if (msg.length() > 0) {
            buf.append(": ").append(msg);
        }
        this.log(3, buf.toString());
        this.frames.push(taskName);
    }

    public void infoEntering(String taskName) {
        this.infoEntering(taskName, null);
    }

    public void infoExiting(String msg) {
        if (msg == null) {
            msg = "";
        }
        try {
            String taskName = this.frames.pop();
            StringBuilder buf = new StringBuilder(5 + taskName.length() + msg.length());
            buf.append(PREFIX_STEP_OUT).append(taskName);
            if (msg.length() > 0) {
                buf.append(": ").append(msg);
            }
            this.log(3, buf.toString());
        }
        catch (EmptyStackException e) {
            this.log(2, "(INVALID) Exiting without no entering" + msg);
        }
    }

    public void infoExiting() {
        this.infoExiting(null);
    }

    public void debug(String msg) {
        this.log(4, msg);
    }

    public void log(int level, String msg) {
        if (msg != null && this.isLoggable(level)) {
            if (PREFIX_LEVELS[level] != null || !this.frames.empty()) {
                StringBuilder buf = new StringBuilder(msg.length() + this.frames.size() * 3 + 3);
                for (int i = this.frames.size(); i > 0; --i) {
                    buf.append(DEPTH_STRING);
                }
                if (PREFIX_LEVELS[level] != null) {
                    buf.append(PREFIX_LEVELS[level]);
                }
                buf.append(msg);
                msg = buf.toString();
            }
            System.out.println(msg);
        }
    }
}

