/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.test;

import foundation.icon.icx.data.TransactionResult;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.test.Env;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EventLog {
    private final boolean debug;
    private final String score;
    private final String[] params;

    public EventLog(boolean debug, String score, String ... params) {
        this.debug = debug;
        this.score = score;
        this.params = params;
    }

    public EventLog(String score, String ... params) {
        this(false, score, params);
    }

    public boolean check(TransactionResult.EventLog log) {
        if (this.score != null && !this.score.equals(log.getScoreAddress())) {
            return false;
        }
        ArrayList items = new ArrayList(log.getIndexed());
        List data = log.getData();
        if (data != null) {
            items.addAll(data);
        }
        for (int idx = 0; idx < this.params.length; ++idx) {
            this.debugInfo(String.format("params[%d] = %s", idx, this.params[idx]));
            if (this.params[idx] == null) continue;
            RpcItem item = (RpcItem)items.get(idx);
            this.debugInfo(String.format("     item = %s", item != null ? item.asString() : "null"));
            if (item == null) {
                return false;
            }
            if (this.params[idx].equals(item.asString())) continue;
            return false;
        }
        return true;
    }

    public static boolean checkScenario(List<EventLog> scenario, TransactionResult result) {
        Iterator<EventLog> itr = scenario.iterator();
        EventLog seq = itr.next();
        for (TransactionResult.EventLog log : result.getEventLogs()) {
            if (!seq.check(log)) continue;
            if (!itr.hasNext()) {
                return true;
            }
            seq = itr.next();
        }
        return false;
    }

    private void debugInfo(String msg) {
        if (this.debug) {
            Env.LOG.info(msg);
        }
    }
}

