/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.test;

import foundation.icon.icx.KeyWallet;
import foundation.icon.icx.Wallet;
import foundation.icon.icx.crypto.KeystoreException;
import foundation.icon.test.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;

public class Env {
    public static final Log LOG = Log.getGlobal();
    private static Chain chain;
    private static String scoreRoot;

    private static void readProperties(Properties props, String confPath) {
        KeyWallet godWallet;
        String chainName = "chain";
        String nid = props.getProperty(chainName + ".nid");
        if (nid == null) {
            throw new IllegalArgumentException("nid not found");
        }
        String godWalletPath = confPath + props.getProperty(chainName + ".godWallet");
        String godPassword = props.getProperty(chainName + ".godPassword");
        try {
            godWallet = Env.readWalletFromFile(godWalletPath, godPassword);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        String nodeName = "node";
        String url = props.getProperty(nodeName + ".url");
        if (url == null) {
            throw new IllegalArgumentException("node url not found");
        }
        chain = new Chain(Integer.parseInt(nid.substring(2), 16), (Wallet)godWallet, url);
        scoreRoot = props.getProperty("score.root");
        if (scoreRoot != null && !scoreRoot.endsWith("/")) {
            scoreRoot = scoreRoot + "/";
        }
    }

    private static KeyWallet readWalletFromFile(String path, String password) throws IOException {
        try {
            File file = new File(path);
            return KeyWallet.load((String)password, (File)file);
        }
        catch (KeystoreException e) {
            e.printStackTrace();
            throw new IOException("Key load failed!");
        }
    }

    public static String getScoreRoot() {
        return scoreRoot;
    }

    public static Chain getDefaultChain() {
        if (chain == null) {
            throw new AssertionError((Object)"Chain not found");
        }
        return chain;
    }

    static {
        String envFile = System.getProperty("env.props", "conf/env.props");
        Properties props = new Properties();
        try {
            LOG.info("Using env.props: " + envFile);
            FileInputStream fis = new FileInputStream(envFile);
            props.load(fis);
            fis.close();
        }
        catch (IOException e) {
            System.err.printf("'%s' does not exist\n", envFile);
            throw new IllegalArgumentException(e.getMessage());
        }
        String confPath = Path.of(envFile, new String[0]).getParent().toString() + "/";
        Env.readProperties(props, confPath);
    }

    public static class Chain {
        public final int networkId;
        public final Wallet godWallet;
        private final String nodeUrl;

        public Chain(int networkId, Wallet godWallet, String url) {
            this.networkId = networkId;
            this.godWallet = godWallet;
            this.nodeUrl = url;
        }

        public String getEndpointURL(int v) {
            return this.nodeUrl + "/api/v" + v;
        }
    }
}

