/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.btp.xcall;

import foundation.icon.btp.lib.BMCScoreInterface;
import foundation.icon.btp.lib.BSH;
import foundation.icon.btp.lib.BTPAddress;
import foundation.icon.btp.xcall.CSMessage;
import foundation.icon.btp.xcall.CSMessageRequest;
import foundation.icon.btp.xcall.CSMessageResponse;
import foundation.icon.btp.xcall.CallRequest;
import foundation.icon.btp.xcall.CallService;
import foundation.icon.btp.xcall.CallServiceEvent;
import foundation.icon.btp.xcall.DAppProxy;
import foundation.icon.btp.xcall.FeeManage;
import java.math.BigInteger;
import java.util.Arrays;
import score.Address;
import score.Context;
import score.DictDB;
import score.RevertedException;
import score.UserRevertedException;
import score.VarDB;
import score.annotation.EventLog;
import score.annotation.External;
import score.annotation.Optional;
import score.annotation.Payable;

public class CallServiceImpl
implements BSH,
CallService,
CallServiceEvent,
FeeManage {
    public static final int MAX_DATA_SIZE = 2048;
    public static final int MAX_ROLLBACK_SIZE = 1024;
    private final VarDB<Address> bmc = Context.newVarDB((String)"bmc", Address.class);
    private final VarDB<BTPAddress> btpAddress = Context.newVarDB((String)"btpAddress", BTPAddress.class);
    private final VarDB<BigInteger> sn = Context.newVarDB((String)"sn", BigInteger.class);
    private final VarDB<BigInteger> reqId = Context.newVarDB((String)"reqId", BigInteger.class);
    private final DictDB<BigInteger, CallRequest> requests = Context.newDictDB((String)"requests", CallRequest.class);
    private final DictDB<BigInteger, CSMessageRequest> proxyReqs = Context.newDictDB((String)"proxyReqs", CSMessageRequest.class);
    private final VarDB<Address> admin = Context.newVarDB((String)"admin", Address.class);
    private final VarDB<Address> feeHandler = Context.newVarDB((String)"feeHandler", Address.class);
    private final VarDB<BigInteger> protocolFee = Context.newVarDB((String)"protocolFee", BigInteger.class);

    public CallServiceImpl(Address _bmc) {
        if (this.bmc.get() == null) {
            this.bmc.set((Object)_bmc);
            BMCScoreInterface bmcInterface = new BMCScoreInterface(_bmc);
            BTPAddress bmcAddress = BTPAddress.valueOf((String)bmcInterface.getBtpAddress());
            this.btpAddress.set((Object)new BTPAddress(bmcAddress.net(), Context.getAddress().toString()));
        }
    }

    @External(readonly=true)
    public String getBtpAddress() {
        return ((BTPAddress)this.btpAddress.get()).toString();
    }

    private void checkCallerOrThrow(Address caller, String errMsg) {
        Context.require((boolean)Context.getCaller().equals((Object)caller), (String)errMsg);
    }

    private void onlyOwner() {
        this.checkCallerOrThrow(Context.getOwner(), "OnlyOwner");
    }

    private void onlyBMC() {
        this.checkCallerOrThrow((Address)this.bmc.get(), "OnlyBMC");
    }

    private void checkService(String _svc) {
        Context.require((boolean)"xcall".equals(_svc), (String)"InvalidServiceName");
    }

    private BigInteger getNextSn() {
        BigInteger _sn = (BigInteger)this.sn.getOrDefault((Object)BigInteger.ZERO);
        _sn = _sn.add(BigInteger.ONE);
        this.sn.set((Object)_sn);
        return _sn;
    }

    private BigInteger getNextReqId() {
        BigInteger _reqId = (BigInteger)this.reqId.getOrDefault((Object)BigInteger.ZERO);
        _reqId = _reqId.add(BigInteger.ONE);
        this.reqId.set((Object)_reqId);
        return _reqId;
    }

    private void cleanupCallRequest(BigInteger sn) {
        this.requests.set((Object)sn, null);
    }

    private byte[] getDataHash(byte[] data) {
        return Context.hash((String)"keccak-256", (byte[])data);
    }

    @Override
    @Payable
    @External
    public BigInteger sendCallMessage(String _to, byte[] _data, @Optional byte[] _rollback) {
        Address caller = Context.getCaller();
        Context.require((caller.isContract() || _rollback == null ? 1 : 0) != 0, (String)"RollbackNotPossible");
        Context.require((_data.length <= 2048 ? 1 : 0) != 0, (String)"MaxDataSizeExceeded");
        Context.require((_rollback == null || _rollback.length <= 1024 ? 1 : 0) != 0, (String)"MaxRollbackSizeExceeded");
        boolean needResponse = _rollback != null;
        BTPAddress dst = BTPAddress.valueOf((String)_to);
        BigInteger value = Context.getValue();
        BigInteger requiredFee = this.getFee(dst.net(), needResponse);
        Context.require((value.compareTo(requiredFee) >= 0 ? 1 : 0) != 0, (String)"InsufficientFee");
        Address feeHandler = this.getProtocolFeeHandler();
        BigInteger protocolFee = this.getProtocolFee();
        if (feeHandler != null && protocolFee.signum() > 0) {
            Context.transfer((Address)feeHandler, (BigInteger)protocolFee);
        }
        BigInteger relayFee = value.subtract(protocolFee);
        BigInteger sn = this.getNextSn();
        if (needResponse) {
            CallRequest req = new CallRequest(caller, dst.toString(), _rollback);
            this.requests.set((Object)sn, (Object)req);
        }
        CSMessageRequest msgReq = new CSMessageRequest(caller.toString(), dst.account(), sn, needResponse, _data);
        BigInteger nsn = this.sendBTPMessage(relayFee, dst.net(), 1, needResponse ? sn : BigInteger.ZERO, msgReq.toBytes());
        this.CallMessageSent(caller, dst.toString(), sn, nsn);
        return sn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @External
    public void executeCall(BigInteger _reqId, byte[] _data) {
        CSMessageRequest req = (CSMessageRequest)this.proxyReqs.get((Object)_reqId);
        Context.require((req != null ? 1 : 0) != 0, (String)"InvalidRequestId");
        Context.require((boolean)Arrays.equals(this.getDataHash(_data), req.getData()), (String)"DataHashMismatch");
        this.proxyReqs.set((Object)_reqId, null);
        BTPAddress from = BTPAddress.valueOf((String)req.getFrom());
        CSMessageResponse msgRes = null;
        try {
            DAppProxy proxy = new DAppProxy(Address.fromString((String)req.getTo()));
            proxy.handleCallMessage(req.getFrom(), _data);
            msgRes = new CSMessageResponse(req.getSn(), 0, "");
        }
        catch (UserRevertedException e) {
            int code = e.getCode();
            String msg = "UserReverted(" + code + ")";
            msgRes = new CSMessageResponse(req.getSn(), code == 0 ? -1 : code, msg);
        }
        catch (IllegalArgumentException | RevertedException e) {
            msgRes = new CSMessageResponse(req.getSn(), -1, e.toString());
        }
        finally {
            if (msgRes == null) {
                msgRes = new CSMessageResponse(req.getSn(), -1, "UnknownFailure");
            }
            this.CallExecuted(_reqId, msgRes.getCode(), msgRes.getMsg());
            if (req.needRollback()) {
                BigInteger sn = req.getSn().negate();
                this.sendBTPMessage(BigInteger.ZERO, from.net(), 2, sn, msgRes.toBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @External
    public void executeRollback(BigInteger _sn) {
        CallRequest req = (CallRequest)this.requests.get((Object)_sn);
        Context.require((req != null ? 1 : 0) != 0, (String)"InvalidSerialNum");
        Context.require((boolean)req.enabled(), (String)"RollbackNotEnabled");
        this.cleanupCallRequest(_sn);
        CSMessageResponse msgRes = null;
        try {
            DAppProxy proxy = new DAppProxy(req.getFrom());
            proxy.handleCallMessage(((BTPAddress)this.btpAddress.get()).toString(), req.getRollback());
            msgRes = new CSMessageResponse(_sn, 0, "");
        }
        catch (UserRevertedException e) {
            int code = e.getCode();
            String msg = "UserReverted(" + code + ")";
            msgRes = new CSMessageResponse(_sn, code == 0 ? -1 : code, msg);
        }
        catch (IllegalArgumentException | RevertedException e) {
            msgRes = new CSMessageResponse(_sn, -1, e.toString());
        }
        finally {
            if (msgRes == null) {
                msgRes = new CSMessageResponse(_sn, -1, "UnknownFailure");
            }
            this.RollbackExecuted(_sn, msgRes.getCode(), msgRes.getMsg());
        }
    }

    @Override
    @EventLog(indexed=3)
    public void CallMessage(String _from, String _to, BigInteger _sn, BigInteger _reqId, byte[] _data) {
    }

    @Override
    @EventLog(indexed=1)
    public void CallExecuted(BigInteger _reqId, int _code, String _msg) {
    }

    @Override
    @EventLog(indexed=1)
    public void ResponseMessage(BigInteger _sn, int _code, String _msg) {
    }

    @Override
    @EventLog(indexed=1)
    public void RollbackMessage(BigInteger _sn) {
    }

    @Override
    @EventLog(indexed=1)
    public void RollbackExecuted(BigInteger _sn, int _code, String _msg) {
    }

    @Override
    @EventLog(indexed=3)
    public void CallMessageSent(Address _from, String _to, BigInteger _sn, BigInteger _nsn) {
    }

    @External
    public void handleBTPMessage(String _from, String _svc, BigInteger _sn, byte[] _msg) {
        this.onlyBMC();
        this.checkService(_svc);
        CSMessage msg = CSMessage.fromBytes(_msg);
        switch (msg.getType()) {
            case 1: {
                this.handleRequest(_from, _sn, msg.getData());
                break;
            }
            case 2: {
                this.handleResponse(_from, _sn, msg.getData());
                break;
            }
            default: {
                Context.revert((String)("UnknownMsgType(" + msg.getType() + ")"));
            }
        }
    }

    @External
    public void handleBTPError(String _src, String _svc, BigInteger _sn, long _code, String _msg) {
        this.onlyBMC();
        this.checkService(_svc);
        String errMsg = "BTPError{code=" + _code + ", msg=" + _msg + "}";
        CSMessageResponse res = new CSMessageResponse(_sn, -2, errMsg);
        this.handleResponse(_src, _sn, res.toBytes());
    }

    private BigInteger sendBTPMessage(BigInteger value, String netTo, int msgType, BigInteger sn, byte[] data) {
        CSMessage msg = new CSMessage(msgType, data);
        BMCScoreInterface bmc = new BMCScoreInterface((Address)this.bmc.get());
        return bmc.sendMessage(value, netTo, "xcall", sn, msg.toBytes());
    }

    private void handleRequest(String netFrom, BigInteger sn, byte[] data) {
        CSMessageRequest msgReq = CSMessageRequest.fromBytes(data);
        BTPAddress from = new BTPAddress(netFrom, msgReq.getFrom());
        String to = msgReq.getTo();
        BigInteger reqId = this.getNextReqId();
        CSMessageRequest req = new CSMessageRequest(from.toString(), to, msgReq.getSn(), msgReq.needRollback(), this.getDataHash(msgReq.getData()));
        this.proxyReqs.set((Object)reqId, (Object)req);
        this.CallMessage(from.toString(), to, msgReq.getSn(), reqId, msgReq.getData());
    }

    private void handleResponse(String netFrom, BigInteger sn, byte[] data) {
        CSMessageResponse msgRes = CSMessageResponse.fromBytes(data);
        BigInteger resSn = msgRes.getSn();
        CallRequest req = (CallRequest)this.requests.get((Object)resSn);
        if (req == null) {
            Context.println((String)("handleResponse: no request for " + resSn));
            return;
        }
        String errMsg = msgRes.getMsg();
        this.ResponseMessage(resSn, msgRes.getCode(), errMsg != null ? errMsg : "");
        switch (msgRes.getCode()) {
            case 0: {
                this.cleanupCallRequest(resSn);
                break;
            }
            default: {
                Context.require((req.getRollback() != null ? 1 : 0) != 0, (String)"NoRollbackData");
                req.setEnabled();
                this.requests.set((Object)resSn, (Object)req);
                this.RollbackMessage(resSn);
            }
        }
    }

    @External(readonly=true)
    public Address admin() {
        return (Address)this.admin.getOrDefault((Object)Context.getOwner());
    }

    @External
    public void setAdmin(Address _address) {
        this.onlyOwner();
        this.admin.set((Object)_address);
    }

    @Override
    @External
    public void setProtocolFeeHandler(@Optional Address _addr) {
        BigInteger accruedFees;
        this.checkCallerOrThrow(this.admin(), "OnlyAdmin");
        this.feeHandler.set((Object)_addr);
        if (_addr != null && (accruedFees = Context.getBalance((Address)Context.getAddress())).signum() > 0) {
            Context.transfer((Address)_addr, (BigInteger)accruedFees);
        }
    }

    @Override
    @External(readonly=true)
    public Address getProtocolFeeHandler() {
        return (Address)this.feeHandler.get();
    }

    @Override
    @External
    public void setProtocolFee(BigInteger _value) {
        this.checkCallerOrThrow(this.admin(), "OnlyAdmin");
        Context.require((_value.signum() >= 0 ? 1 : 0) != 0, (String)"ValueShouldBePositive");
        this.protocolFee.set((Object)_value);
    }

    @Override
    @External(readonly=true)
    public BigInteger getProtocolFee() {
        return (BigInteger)this.protocolFee.getOrDefault((Object)BigInteger.ZERO);
    }

    @Override
    @External(readonly=true)
    public BigInteger getFee(String _net, boolean _rollback) {
        if (_net.isEmpty() || _net.indexOf(47) != -1 || _net.indexOf(58) != -1) {
            Context.revert((String)"InvalidNetworkAddress");
        }
        BMCScoreInterface bmc = new BMCScoreInterface((Address)this.bmc.get());
        BigInteger relayFee = bmc.getFee(_net, _rollback);
        return this.getProtocolFee().add(relayFee);
    }
}

