/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.btp.xcall;

import score.Address;
import score.ObjectReader;
import score.ObjectWriter;

public class CallRequest {
    private final Address from;
    private final String to;
    private final byte[] rollback;
    private boolean enabled;

    public CallRequest(Address from, String to, byte[] rollback) {
        this.from = from;
        this.to = to;
        this.rollback = rollback;
        this.enabled = false;
    }

    public Address getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public byte[] getRollback() {
        return this.rollback;
    }

    public static void writeObject(ObjectWriter w, CallRequest req) {
        w.beginList(4);
        w.write(req.from);
        w.write(req.to);
        w.writeNullable((Object)req.rollback);
        w.write(req.enabled);
        w.end();
    }

    public static CallRequest readObject(ObjectReader r) {
        r.beginList();
        CallRequest req = new CallRequest(r.readAddress(), r.readString(), (byte[])r.readNullable(byte[].class));
        if (r.readBoolean()) {
            req.setEnabled();
        }
        r.end();
        return req;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnabled() {
        this.enabled = true;
    }
}

