/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.collections;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;

final class ValidationQueue<E>
implements Queue<E> {
    private final long timeout;
    private final boolean removeOnNext;
    private final Node<E> head;
    private final Node<E> tail;
    private final Size size;

    ValidationQueue(Duration timeout, Mode mode) {
        this(new Node(null), new Node(null), new Size(), Objects.requireNonNull(timeout, "Timeout cannot be null."), Objects.requireNonNull(mode, "Mode cannot be null.") == Mode.REMOVE_ON_NEXT);
        this.clear();
    }

    private ValidationQueue(Node<E> head, Node<E> tail, Size size, Duration timeout, boolean removeOnNext) {
        this.head = head;
        this.tail = tail;
        this.size = size;
        this.timeout = timeout.toMillis();
        this.removeOnNext = removeOnNext;
    }

    ValidationQueue<E> view(Duration timeout) {
        return new ValidationQueue<E>(this.head, this.tail, this.size, timeout, this.removeOnNext);
    }

    private boolean end(Node<E> node) {
        return node == this.tail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<E> getNext(Node<E> node) {
        Node<E> node2 = this.head;
        synchronized (node2) {
            long r = this.timeout;
            long d = System.currentTimeMillis() + r;
            while (this.end(((Node)node).next) && r > 0L) {
                try {
                    this.head.wait(r);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                r = d - System.currentTimeMillis();
            }
            return ((Node)node).next;
        }
    }

    private void to(Node<E> prev, Node<E> next) {
        ((Node)prev).next = (Node)next;
        ((Node)next).prev = (Node)prev;
    }

    private void removeNode(Node<E> node) {
        this.size.size--;
        this.to(((Node)node).prev, ((Node)node).next);
    }

    @Override
    public int size() {
        return this.size.size;
    }

    @Override
    public boolean isEmpty() {
        return this.end(((Node)this.head).next);
    }

    @Override
    public boolean contains(Object o) {
        for (E e : this) {
            if (!e.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new AsynchronousEventsIterator();
    }

    @Override
    public Object[] toArray() {
        LinkedList<Object> list = new LinkedList<Object>();
        Node node = ((Node)this.head).next;
        while (!this.end(node)) {
            list.add(node.value);
            node = node.next;
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        LinkedList<Object> list = new LinkedList<Object>();
        Node node = ((Node)this.head).next;
        while (!this.end(node)) {
            list.add(node.value);
            node = node.next;
        }
        return list.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Node<E> node = this.head;
        synchronized (node) {
            Node node2 = new Node(e);
            this.to(((Node)this.tail).prev, node2);
            this.to(node2, this.tail);
            this.size.size++;
            this.head.notifyAll();
            return false;
        }
    }

    @Override
    public boolean remove(Object o) {
        Node node = ((Node)this.head).next;
        while (!this.end(node)) {
            if (node.value.equals(o)) {
                this.removeNode(node);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        HashSet set = new HashSet(c);
        for (E e : this) {
            set.remove(e);
        }
        return set.isEmpty();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        c.forEach(this::add);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        HashSet set = new HashSet(c);
        boolean result = false;
        Node node = ((Node)this.head).next;
        while (!this.end(node)) {
            if (set.contains(node.value)) {
                this.removeNode(node);
                result = true;
            }
            node = node.next;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet set = new HashSet(c);
        boolean result = false;
        Node node = ((Node)this.head).next;
        while (!this.end(node)) {
            if (!set.contains(node.value)) {
                this.removeNode(node);
                result = true;
            }
            node = node.next;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Node<E> node = this.head;
        synchronized (node) {
            this.to(this.head, this.tail);
            this.size.size = 0;
        }
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    private E checkElement(E element) {
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public E remove() {
        return this.checkElement(this.poll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Node<E> node = this.head;
        synchronized (node) {
            Node<E> node2 = this.getNext(this.head);
            if (this.end(node2)) {
                return null;
            }
            this.removeNode(node2);
            return (E)((Node)node2).value;
        }
    }

    @Override
    public E element() {
        return this.checkElement(this.peek());
    }

    @Override
    public E peek() {
        Node<E> node = this.getNext(this.head);
        return (E)(this.end(node) ? null : ((Node)node).value);
    }

    private class AsynchronousEventsIterator
    implements Iterator<E> {
        private Node<E> node;

        private AsynchronousEventsIterator() {
            this.node = ValidationQueue.this.head;
        }

        @Override
        public boolean hasNext() {
            return !ValidationQueue.this.end(ValidationQueue.this.getNext(this.node));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Node node = ValidationQueue.this.head;
            synchronized (node) {
                Node next = ValidationQueue.this.getNext(this.node);
                if (ValidationQueue.this.end(next)) {
                    throw new NoSuchElementException();
                }
                if (ValidationQueue.this.removeOnNext && this.node != ValidationQueue.this.head) {
                    ValidationQueue.this.removeNode(this.node);
                }
                this.node = next;
                return next.value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Node node = ValidationQueue.this.head;
            synchronized (node) {
                if (this.node == ValidationQueue.this.head) {
                    throw new IllegalStateException("next() not called yet");
                }
                ValidationQueue.this.removeNode(this.node);
            }
        }
    }

    public static enum Mode {
        KEEP_ALL,
        REMOVE_ON_NEXT;

    }

    private static final class Size {
        private int size = 0;

        private Size() {
        }
    }

    private static final class Node<E> {
        private final E value;
        private Node<E> next;
        private Node<E> prev;

        private Node(E value) {
            this.value = value;
        }
    }
}

