/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.collections;

import fluent.validation.collections.RepeatingIterable;
import fluent.validation.collections.ValidationQueue;
import java.time.Duration;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Supplier;

public final class ValidationCollections {
    public static <D> RepeatingIterable<D> repeatingIterable(Supplier<? extends D> supplier, int maxAttempts, Duration delay) {
        Objects.requireNonNull(delay, "Delay must not be null.");
        return ValidationCollections.repeatingIterable(supplier, maxAttempts, () -> {
            try {
                Thread.sleep(delay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        });
    }

    public static <D> RepeatingIterable<D> repeatingIterable(Supplier<? extends D> supplier, int maxAttempts, Runnable update) {
        return new RepeatingIterable<D>(supplier, maxAttempts, update);
    }

    public static <D> ValidationQueue<D> validationQueue(Duration timeout, ValidationQueue.Mode mode) {
        return new ValidationQueue(timeout, mode);
    }

    public static <D> ValidationQueue<D> validationQueue(Duration timeout) {
        return ValidationCollections.validationQueue(timeout, ValidationQueue.Mode.KEEP_ALL);
    }

    public static <D> ValidationQueue<D> removingValidationQueue(Duration timeout) {
        return ValidationCollections.validationQueue(timeout, ValidationQueue.Mode.REMOVE_ON_NEXT);
    }

    public static <E> Queue<E> view(Queue<E> queue, Duration timeout) {
        return queue instanceof ValidationQueue ? ((ValidationQueue)queue).view(timeout) : queue;
    }
}

