/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.collections;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;

public final class RepeatingIterable<D>
implements Iterable<D> {
    private final Supplier<? extends D> supplier;
    private final int maxAttempts;
    private final Runnable update;

    RepeatingIterable(Supplier<? extends D> supplier, int maxAttempts, Runnable update) {
        this.supplier = Objects.requireNonNull(supplier, "Supplier must not be null.");
        this.maxAttempts = maxAttempts;
        this.update = Objects.requireNonNull(update, "Update must not be null.");
    }

    @Override
    public Iterator<D> iterator() {
        return new Iterator<D>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < RepeatingIterable.this.maxAttempts;
            }

            @Override
            public D next() {
                if (this.i > 0) {
                    RepeatingIterable.this.update.run();
                }
                ++this.i;
                return RepeatingIterable.this.supplier.get();
            }
        };
    }
}

