/*
 * Decompiled with CFR 0.152.
 */
package foundation.jpa.querydsl.spring.impl;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import foundation.jpa.querydsl.QueryExecutor;
import foundation.jpa.querydsl.QueryVariables;
import foundation.jpa.querydsl.spring.AggregateCriteria;
import foundation.jpa.querydsl.spring.JpaQueryExecutor;
import foundation.jpa.querydsl.spring.SearchCriteria;
import foundation.jpa.querydsl.spring.SearchEngine;
import foundation.jpa.querydsl.spring.SearchResult;
import foundation.jpa.querydsl.spring.impl.AggregationResultImpl;
import foundation.jpa.querydsl.spring.impl.SearchCriteriaImpl;
import foundation.jpa.querydsl.spring.impl.SearchResultImpl;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class SearchEngineImpl
implements SearchEngine {
    private final JPAQueryFactory queryFactory;
    private final QueryExecutor queryExecutor;

    public SearchEngineImpl(JPAQueryFactory queryFactory, QueryExecutor queryExecutor) {
        this.queryFactory = queryFactory;
        this.queryExecutor = queryExecutor;
    }

    public SearchEngineImpl(EntityManager entityManager) {
        this(new JPAQueryFactory(entityManager), new JpaQueryExecutor(entityManager));
    }

    @Override
    public <E> SearchResult<E> search(SearchCriteria<? extends EntityPath<E>> criteria, QueryVariables variables) {
        return this.search(criteria, variables, this.queryFactory.selectFrom(criteria.getEntityPath()));
    }

    @Override
    public <E> SearchResult<E> search(Predicate implicitPredicate, SearchCriteria<? extends EntityPath<E>> criteria, QueryVariables variables) {
        return this.search(criteria, variables, (JPAQuery)this.queryFactory.selectFrom(criteria.getEntityPath()).where(implicitPredicate));
    }

    @Override
    public <E> SearchResult<E> search(EntityPath<E> entityPath, String query, String sort, Pageable pageable, QueryVariables variables) {
        return this.search(new SearchCriteriaImpl<EntityPath<E>>("query", query, sort, pageable, entityPath), variables);
    }

    @Override
    public <E> SearchResult<List<?>> aggregate(AggregateCriteria<? extends EntityPath<E>> criteria, QueryVariables variables) {
        try {
            JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.queryFactory.selectFrom(criteria.getEntityPath()).where(this.queryExecutor.parsePredicate(criteria.getEntityPath(), criteria.getQuery(), variables))).orderBy(this.queryExecutor.parseOrderSpecifier(criteria.getEntityPath(), criteria.getSort()))).groupBy(this.queryExecutor.parseSelect(criteria.getEntityPath(), criteria.groupBy(), variables))).select((Expression)Projections.list((Expression[])this.queryExecutor.parseSelect(criteria.getEntityPath(), criteria.select(), variables))).offset(criteria.getPageable().getOffset())).limit((long)criteria.getPageable().getPageSize());
            return new AggregationResultImpl((Page<List<?>>)new PageImpl(query.fetch(), criteria.getPageable(), query.fetchCount()), null);
        }
        catch (Throwable e) {
            return new AggregationResultImpl(Page.empty(), e);
        }
    }

    private <E> SearchResult<E> search(SearchCriteria<? extends EntityPath<E>> criteria, QueryVariables variables, JPAQuery<E> jpaQuery) {
        try {
            JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.where(this.queryExecutor.parsePredicate(criteria.getEntityPath(), criteria.getQuery(), variables))).orderBy(this.queryExecutor.parseOrderSpecifier(criteria.getEntityPath(), criteria.getSort()))).offset(criteria.getPageable().getOffset())).limit((long)criteria.getPageable().getPageSize());
            return new SearchResultImpl(criteria, new PageImpl(query.fetch(), criteria.getPageable(), query.fetchCount()), null);
        }
        catch (Throwable e) {
            return new SearchResultImpl(criteria, Page.empty(), e);
        }
    }
}

