/*
 * Decompiled with CFR 0.152.
 */
package foundation.jpa.querydsl.spring;

import com.querydsl.core.types.EntityPath;
import foundation.jpa.querydsl.spring.AggregateCriteria;
import foundation.jpa.querydsl.spring.CacheQuery;
import foundation.jpa.querydsl.spring.DefaultQuery;
import foundation.jpa.querydsl.spring.DefaultSort;
import foundation.jpa.querydsl.spring.impl.AggregateCriteriaImpl;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AggregationCriteriaHandler
implements HandlerMethodArgumentResolver {
    private final int defaultPageSize;
    private final int defaultPage;

    public AggregationCriteriaHandler(int defaultPageSize, int defaultPage) {
        this.defaultPageSize = defaultPageSize;
        this.defaultPage = defaultPage;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return AggregateCriteria.class.equals((Object)methodParameter.getParameterType());
    }

    public AggregateCriteria<? extends EntityPath<?>> resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        CacheQuery cacheQuery = (CacheQuery)methodParameter.getParameterAnnotation(CacheQuery.class);
        String typeName = ((ParameterizedType)methodParameter.getGenericParameterType()).getActualTypeArguments()[0].getTypeName();
        String parameterName = methodParameter.getParameterName();
        return new AggregateCriteriaImpl(parameterName, this.get(nativeWebRequest, parameterName, cacheQuery, typeName, this.defaultQuery(methodParameter)), this.get(nativeWebRequest, parameterName + "Order", cacheQuery, typeName, this.defaultSort(methodParameter)), this.pageable((PageableDefault)methodParameter.getMethodAnnotation(PageableDefault.class), parameterName, nativeWebRequest), this.getEntityPath(methodParameter), this.get(nativeWebRequest, parameterName + "GroupBy", cacheQuery, typeName, ""), this.get(nativeWebRequest, parameterName + "Select", cacheQuery, typeName, ""));
    }

    private String defaultQuery(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(DefaultQuery.class) ? ((DefaultQuery)methodParameter.getParameterAnnotation(DefaultQuery.class)).value() : "";
    }

    private String defaultSort(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(DefaultSort.class) ? ((DefaultSort)methodParameter.getParameterAnnotation(DefaultSort.class)).value() : "";
    }

    private String get(NativeWebRequest nativeWebRequest, String name, CacheQuery cacheQuery, String typeName, String defaultValue) {
        String value = nativeWebRequest.getParameter(name);
        if (Objects.nonNull(cacheQuery)) {
            String cacheKey = name + ":" + cacheQuery.value() + typeName;
            if ("delete".equals(nativeWebRequest.getParameter("cache"))) {
                nativeWebRequest.removeAttribute(cacheKey, 1);
            }
            if (Objects.isNull(value)) {
                value = (String)nativeWebRequest.getAttribute(cacheKey, 1);
            } else {
                nativeWebRequest.setAttribute(cacheKey, (Object)value, 1);
            }
        }
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    private <E> EntityPath<E> getEntityPath(MethodParameter parameter) throws IllegalAccessException {
        Type type = ((ParameterizedType)parameter.getGenericParameterType()).getActualTypeArguments()[0];
        Class entityPathClass = (Class)GenericTypeResolver.resolveType((Type)type, (Class)parameter.getContainingClass());
        for (Field field : entityPathClass.getFields()) {
            if (!entityPathClass.equals(field.getType())) continue;
            return (EntityPath)field.get(null);
        }
        throw new IllegalArgumentException("Method parameter " + parameter + " not proper Querydsl generated entity path.");
    }

    private Pageable pageable(PageableDefault pageableDefault, String parameterName, NativeWebRequest request) {
        int page = this.defaultPage;
        int size = this.defaultPageSize;
        if (Objects.nonNull(pageableDefault)) {
            page = pageableDefault.page();
            size = pageableDefault.size();
        }
        String pageParameterName = parameterName + "Page";
        String sizeParameterName = parameterName + "Size";
        if (Objects.nonNull(request.getParameter(pageParameterName))) {
            page = Integer.parseInt(request.getParameter(pageParameterName));
        }
        if (Objects.nonNull(request.getParameter(sizeParameterName))) {
            size = Integer.parseInt(request.getParameter(sizeParameterName));
        }
        return PageRequest.of((int)page, (int)size);
    }
}

