/*
 * Decompiled with CFR 0.152.
 */
package foundation.jpa.querydsl.spring;

import com.querydsl.core.types.EntityPath;
import foundation.jpa.querydsl.spring.CacheQuery;
import foundation.jpa.querydsl.spring.DefaultQuery;
import foundation.jpa.querydsl.spring.DefaultSort;
import foundation.jpa.querydsl.spring.ImplicitQuery;
import foundation.jpa.querydsl.spring.SearchCriteria;
import foundation.jpa.querydsl.spring.impl.SearchCriteriaImpl;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SearchCriteriaHandler
implements HandlerMethodArgumentResolver {
    private final String queryParameterName;
    private final String sortParameterName;
    private final String pageParameterName;
    private final String sizeParameterName;
    private final int defaultPageSize;
    private final int defaultPage;

    public SearchCriteriaHandler(String queryParameterName, String sortParameterName, String pageParameterName, String sizeParameterName, int defaultPageSize, int defaultPage) {
        this.queryParameterName = queryParameterName;
        this.sortParameterName = sortParameterName;
        this.pageParameterName = pageParameterName;
        this.sizeParameterName = sizeParameterName;
        this.defaultPageSize = defaultPageSize;
        this.defaultPage = defaultPage;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return SearchCriteria.class.equals((Object)methodParameter.getParameterType());
    }

    public SearchCriteria<? extends EntityPath<?>> resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        CacheQuery cacheQuery = (CacheQuery)methodParameter.getParameterAnnotation(CacheQuery.class);
        String typeName = ((ParameterizedType)methodParameter.getGenericParameterType()).getActualTypeArguments()[0].getTypeName();
        return new SearchCriteriaImpl(methodParameter.hasParameterAnnotation(ImplicitQuery.class) ? ((ImplicitQuery)methodParameter.getParameterAnnotation(ImplicitQuery.class)).value() : null, this.get(nativeWebRequest, this.queryParameterName, cacheQuery, typeName, this.defaultQuery(methodParameter)), this.get(nativeWebRequest, this.sortParameterName, cacheQuery, typeName, this.defaultSort(methodParameter)), this.pageable((PageableDefault)methodParameter.getMethodAnnotation(PageableDefault.class), nativeWebRequest), this.getEntityPath(methodParameter));
    }

    private String defaultQuery(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(DefaultQuery.class) ? ((DefaultQuery)methodParameter.getParameterAnnotation(DefaultQuery.class)).value() : "";
    }

    private String defaultSort(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(DefaultSort.class) ? ((DefaultSort)methodParameter.getParameterAnnotation(DefaultSort.class)).value() : "";
    }

    private String get(NativeWebRequest nativeWebRequest, String name, CacheQuery cacheQuery, String typeName, String defaultValue) {
        String value = nativeWebRequest.getParameter(name);
        if (Objects.nonNull(cacheQuery)) {
            String cacheKey = name + ":" + cacheQuery.value() + typeName;
            if ("delete".equals(nativeWebRequest.getParameter("cache"))) {
                nativeWebRequest.removeAttribute(cacheKey, 1);
            }
            if (Objects.isNull(value)) {
                value = (String)nativeWebRequest.getAttribute(cacheKey, 1);
            } else {
                nativeWebRequest.setAttribute(cacheKey, (Object)value, 1);
            }
        }
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    private <E> EntityPath<E> getEntityPath(MethodParameter parameter) throws IllegalAccessException {
        Class entityPathClass = (Class)((ParameterizedType)parameter.getGenericParameterType()).getActualTypeArguments()[0];
        for (Field field : entityPathClass.getFields()) {
            if (!entityPathClass.equals(field.getType())) continue;
            return (EntityPath)field.get(null);
        }
        throw new IllegalArgumentException("Method parameter " + parameter + " not proper Querydsl generated entity path.");
    }

    private Pageable pageable(PageableDefault pageableDefault, NativeWebRequest request) {
        int page = this.defaultPage;
        int size = this.defaultPageSize;
        if (Objects.nonNull(pageableDefault)) {
            page = pageableDefault.page();
            size = pageableDefault.size();
        }
        if (Objects.nonNull(request.getParameter(this.pageParameterName))) {
            page = Integer.parseInt(request.getParameter(this.pageParameterName));
        }
        if (Objects.nonNull(request.getParameter(this.sizeParameterName))) {
            size = Integer.parseInt(request.getParameter(this.sizeParameterName));
        }
        return PageRequest.of((int)page, (int)size);
    }
}

