/*
 * Decompiled with CFR 0.152.
 */
package foundation.jpa.querydsl.spring;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import foundation.jpa.querydsl.QueryContext;
import foundation.jpa.querydsl.order.OrderByParser;
import foundation.jpa.querydsl.order.OrderFactory;
import foundation.jpa.querydsl.spring.CacheQuery;
import foundation.jpa.querydsl.spring.DefaultQuery;
import foundation.jpa.querydsl.spring.DefaultSort;
import foundation.jpa.querydsl.spring.ImplicitQuery;
import foundation.jpa.querydsl.spring.Search;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SearchParameterHandler
implements HandlerMethodArgumentResolver {
    private final JPAQueryFactory factory;
    private final QueryContext queryContext;
    private final String queryParameterName;
    private final String sortParameterName;
    private final String pageParameterName;
    private final String sizeParameterName;
    private final int defaultPageSize;
    private final int defaultPage;

    public SearchParameterHandler(EntityManager manager, QueryContext queryContext, String queryParameterName, String sortParameterName, String pageParameterName, String sizeParameterName, int defaultPageSize, int defaultPage) {
        this.factory = new JPAQueryFactory(manager);
        this.queryContext = queryContext;
        this.queryParameterName = queryParameterName;
        this.sortParameterName = sortParameterName;
        this.pageParameterName = pageParameterName;
        this.sizeParameterName = sizeParameterName;
        this.defaultPageSize = defaultPageSize;
        this.defaultPage = defaultPage;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return Search.class.equals((Object)methodParameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        CacheQuery cacheQuery = (CacheQuery)methodParameter.getParameterAnnotation(CacheQuery.class);
        String typeName = ((ParameterizedType)methodParameter.getGenericParameterType()).getActualTypeArguments()[0].getTypeName();
        String query = this.get(nativeWebRequest, this.queryParameterName, cacheQuery, typeName, this.defaultQuery(methodParameter));
        String sort = this.get(nativeWebRequest, this.sortParameterName, cacheQuery, typeName, this.defaultSort(methodParameter));
        Pageable pageable = this.pageable((PageableDefault)methodParameter.getMethodAnnotation(PageableDefault.class), nativeWebRequest);
        return this.execute(this.getEntityPath(methodParameter), query, sort, pageable, URI.create(""), (ImplicitQuery)methodParameter.getParameterAnnotation(ImplicitQuery.class));
    }

    private String defaultQuery(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(DefaultQuery.class) ? ((DefaultQuery)methodParameter.getParameterAnnotation(DefaultQuery.class)).value() : "";
    }

    private String defaultSort(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(DefaultSort.class) ? ((DefaultSort)methodParameter.getParameterAnnotation(DefaultSort.class)).value() : "";
    }

    private String get(NativeWebRequest nativeWebRequest, String name, CacheQuery cacheQuery, String typeName, String defaultValue) {
        String value = nativeWebRequest.getParameter(name);
        if (Objects.nonNull(cacheQuery)) {
            String cacheKey = name + ":" + cacheQuery.value() + typeName;
            if ("delete".equals(nativeWebRequest.getParameter("cache"))) {
                nativeWebRequest.removeAttribute(cacheKey, 1);
            }
            if (Objects.isNull(value)) {
                value = (String)nativeWebRequest.getAttribute(cacheKey, 1);
            } else {
                nativeWebRequest.setAttribute(cacheKey, (Object)value, 1);
            }
        }
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    private <E> OrderSpecifier<?>[] sort(EntityPath<E> path, String sort) throws IOException {
        return (OrderSpecifier[])new OrderByParser(new OrderFactory(path)).parseString(sort);
    }

    private <E, Q extends EntityPath<E>> Search<E, Q> execute(EntityPath<E> type, String query, String sort, Pageable pageable, URI uri, ImplicitQuery implicitQuery) {
        try {
            JPAQuery jpaQuery = this.factory.selectFrom(type);
            if (Objects.nonNull(implicitQuery)) {
                jpaQuery.where(this.queryContext.parse(type, implicitQuery.value()));
            }
            Predicate predicate = this.queryContext.parse(type, query);
            OrderSpecifier<?>[] specifiers = this.sort(type, sort);
            jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.where(predicate)).orderBy(specifiers)).offset(pageable.getOffset())).limit((long)pageable.getPageSize());
            long count = jpaQuery.fetchCount();
            List data = jpaQuery.fetch();
            return Search.search(query, sort, predicate, specifiers, new PageImpl(data, pageable, count), null, uri);
        }
        catch (Throwable e) {
            return Search.search(query, sort, null, null, Page.empty(), e, uri);
        }
    }

    private <E> EntityPath<E> getEntityPath(MethodParameter parameter) throws IllegalAccessException {
        Class entityPathClass = (Class)((ParameterizedType)parameter.getGenericParameterType()).getActualTypeArguments()[1];
        for (Field field : entityPathClass.getFields()) {
            if (!entityPathClass.equals(field.getType())) continue;
            return (EntityPath)field.get(null);
        }
        throw new IllegalArgumentException("Method parameter " + parameter + " not proper Querydsl generated entity path.");
    }

    private Pageable pageable(PageableDefault pageableDefault, NativeWebRequest request) {
        int page = this.defaultPage;
        int size = this.defaultPageSize;
        if (Objects.nonNull(pageableDefault)) {
            page = pageableDefault.page();
            size = pageableDefault.size();
        }
        if (Objects.nonNull(request.getParameter(this.pageParameterName))) {
            page = Integer.parseInt(request.getParameter(this.pageParameterName));
        }
        if (Objects.nonNull(request.getParameter(this.sizeParameterName))) {
            size = Integer.parseInt(request.getParameter(this.sizeParameterName));
        }
        return PageRequest.of((int)page, (int)size);
    }
}

