/*
 * Decompiled with CFR 0.152.
 */
package foundation.jpa.querydsl.spring;

import com.querydsl.core.types.EntityPath;
import com.querydsl.jpa.impl.JPAQuery;
import foundation.jpa.querydsl.QueryContext;
import foundation.jpa.querydsl.spring.CacheQuery;
import foundation.jpa.querydsl.spring.DefaultQuery;
import foundation.jpa.querydsl.spring.ImplicitQuery;
import foundation.jpa.querydsl.spring.Search;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SearchParameterHandler
implements HandlerMethodArgumentResolver {
    private final EntityManager entityManager;
    private final QueryContext queryContext;

    public SearchParameterHandler(EntityManager entityManager, QueryContext queryContext) {
        this.entityManager = entityManager;
        this.queryContext = queryContext;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return Search.class.equals((Object)methodParameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        String query = this.query(methodParameter, nativeWebRequest);
        Pageable pageable = this.pageable((PageableDefault)methodParameter.getMethodAnnotation(PageableDefault.class), nativeWebRequest);
        return this.execute(this.getEntityPath(methodParameter), query, pageable, URI.create(""), (ImplicitQuery)methodParameter.getParameterAnnotation(ImplicitQuery.class));
    }

    private String query(MethodParameter methodParameter, NativeWebRequest nativeWebRequest) {
        DefaultQuery defaultQuery;
        String query = nativeWebRequest.getParameter("query");
        if (methodParameter.hasParameterAnnotation(CacheQuery.class)) {
            String typeName = ((ParameterizedType)methodParameter.getGenericParameterType()).getActualTypeArguments()[0].getTypeName();
            String name = ((CacheQuery)methodParameter.getParameterAnnotation(CacheQuery.class)).value() + typeName;
            if (Objects.isNull(query)) {
                query = (String)nativeWebRequest.getAttribute(name, 1);
            } else {
                nativeWebRequest.setAttribute(name, (Object)query, 1);
            }
        }
        if (Objects.isNull(query) && Objects.nonNull(defaultQuery = (DefaultQuery)methodParameter.getParameterAnnotation(DefaultQuery.class))) {
            query = defaultQuery.value();
        }
        return query;
    }

    private <E, Q extends EntityPath<E>> Search<E, Q> execute(EntityPath<E> type, String query, Pageable pageable, URI uri, ImplicitQuery implicitQuery) {
        try {
            JPAQuery jpaQuery = (JPAQuery)new JPAQuery(this.entityManager).from(type);
            if (Objects.nonNull(implicitQuery)) {
                jpaQuery.where(this.queryContext.parse(type, implicitQuery.value()));
            }
            jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.where(this.queryContext.parse(type, query))).offset(pageable.getOffset())).limit((long)pageable.getPageSize());
            long count = jpaQuery.fetchCount();
            List data = jpaQuery.fetch();
            return Search.search(query, new PageImpl(data, pageable, count), null, uri);
        }
        catch (Throwable e) {
            return Search.search(query, Page.empty(), e, uri);
        }
    }

    private <E> EntityPath<E> getEntityPath(MethodParameter parameter) throws IllegalAccessException {
        Class entityPathClass = (Class)((ParameterizedType)parameter.getGenericParameterType()).getActualTypeArguments()[1];
        for (Field field : entityPathClass.getFields()) {
            if (!entityPathClass.equals(field.getType())) continue;
            return (EntityPath)field.get(null);
        }
        throw new IllegalArgumentException("Method parameter " + parameter + " not proper Querydsl generated entity path.");
    }

    private Pageable pageable(PageableDefault pageableDefault, NativeWebRequest request) {
        int page = 1;
        int size = 10;
        if (Objects.nonNull(pageableDefault)) {
            page = pageableDefault.page();
            size = pageableDefault.size();
        }
        if (Objects.nonNull(request.getParameter("page"))) {
            page = Integer.parseInt(request.getParameter("page"));
        }
        if (Objects.nonNull(request.getParameter("size"))) {
            size = Integer.parseInt(request.getParameter("size"));
        }
        return PageRequest.of((int)page, (int)size);
    }
}

