/*
 * Decompiled with CFR 0.152.
 */
package foundation.jpa.querydsl.spring.autoconfigure;

import foundation.jpa.querydsl.spring.SearchCriteriaHandler;
import foundation.jpa.querydsl.spring.SearchEngine;
import foundation.jpa.querydsl.spring.SearchHandler;
import foundation.jpa.querydsl.spring.impl.SearchEngineImpl;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={EntityManager.class})
public class SearchConfiguration
implements WebMvcConfigurer {
    @Bean
    @ConditionalOnMissingBean
    public SearchCriteriaHandler searchCriteriaHandler(@Value(value="${querydsl.search.queryParameterName:query}") String queryParameterName, @Value(value="${querydsl.search.sortParameterName:sort}") String sortParameterName, @Value(value="${querydsl.search.pageParameterName:page}") String pageParameterName, @Value(value="${querydsl.search.sizeParameterName:size}") String sizeParameterName, @Value(value="${querydsl.search.defaultPage:0}") int defaultPage, @Value(value="${querydsl.search.defaultPageSize:10}") int defaultPageSize) {
        return new SearchCriteriaHandler(queryParameterName, sortParameterName, pageParameterName, sizeParameterName, defaultPageSize, defaultPage);
    }

    @Bean
    @ConditionalOnMissingBean
    public SearchEngine searchEngine(EntityManager entityManager) {
        return new SearchEngineImpl(entityManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public SearchHandler searchHandler(SearchCriteriaHandler searchCriteriaHandler, SearchEngine searchEngine) {
        return new SearchHandler(searchCriteriaHandler, searchEngine);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add((HandlerMethodArgumentResolver)this.searchHandler(null, null));
        resolvers.add((HandlerMethodArgumentResolver)this.searchCriteriaHandler(null, null, null, null, 0, 0));
    }
}

