/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.parser;

import foundation.rpg.parser.Input;
import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.ParseErrorException;
import foundation.rpg.parser.StateBase;
import foundation.rpg.parser.TokenInput;
import foundation.rpg.parser.TokenInputParser;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class StreamParser<R, S extends StateBase<R>> {
    private final TokenInputParser<R, S> parser;
    private final Lexer<S> lexer;

    public StreamParser(S initialState, Lexer<S> lexer) {
        this.parser = new TokenInputParser(initialState);
        this.lexer = lexer;
    }

    public R parse(TokenInput<S> input) throws ParseErrorException {
        return this.parser.parse(input);
    }

    public R parse(String name, Reader reader) throws IOException, ParseErrorException {
        return this.parse(TokenInput.tokenInput(new Input(name, reader), this.lexer));
    }

    public R parseFile(String fileName) throws IOException, ParseErrorException {
        return this.parse(fileName, new FileReader(fileName));
    }

    public R parseString(String content) throws IOException, ParseErrorException {
        return this.parse("string", new StringReader(content));
    }

    public R parse(String name, InputStream stream) throws IOException, ParseErrorException {
        return this.parse(name, new InputStreamReader(stream));
    }
}

