/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.parser;

import foundation.rpg.parser.Element;
import foundation.rpg.parser.Input;
import foundation.rpg.parser.ParseErrorException;
import java.io.IOException;

@FunctionalInterface
public interface Lexer<S> {
    public Element<S> next(Input var1) throws ParseErrorException, IOException;

    public static boolean matchesGroup(String group, int c) {
        switch (group) {
            case ".": {
                return true;
            }
            case "w": {
                return Character.isJavaIdentifierPart(c);
            }
            case "d": {
                return Character.isDigit(c);
            }
            case "s": {
                return Character.isWhitespace(c);
            }
            case "i": {
                return Character.isJavaIdentifierStart(c);
            }
            case "u": {
                return Character.isUnicodeIdentifierStart(c);
            }
            case "x": {
                return Character.isUnicodeIdentifierPart(c);
            }
            case "W": {
                return !Character.isJavaIdentifierPart(c);
            }
            case "D": {
                return !Character.isDigit(c);
            }
            case "S": {
                return !Character.isWhitespace(c);
            }
            case "I": {
                return !Character.isJavaIdentifierStart(c);
            }
            case "U": {
                return !Character.isUnicodeIdentifierStart(c);
            }
            case "X": {
                return !Character.isUnicodeIdentifierPart(c);
            }
        }
        return false;
    }
}

