/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.parser;

import foundation.rpg.parser.Input;
import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.ParseErrorException;
import foundation.rpg.parser.Parser;
import foundation.rpg.parser.StateBase;
import foundation.rpg.parser.TokenInput;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Consumer;

public class Compiler<R, S extends StateBase<R>> {
    private final Lexer<S> lexer;
    private final Parser<R, S> parser;
    private final Consumer<? super R> consumer;

    public Compiler(Lexer<S> lexer, Parser<R, S> parser, Consumer<? super R> consumer) {
        this.lexer = lexer;
        this.parser = parser;
        this.consumer = consumer;
    }

    public void compile(String file) throws IOException, ParseErrorException {
        this.consumer.accept(this.parser.parse(TokenInput.tokenInput(new Input(file, new FileReader(file)), this.lexer)));
    }

    public void compile(String name, Reader reader) throws IOException, ParseErrorException {
        this.consumer.accept(this.parser.parse(TokenInput.tokenInput(new Input(name, reader), this.lexer)));
    }
}

